/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact;

import java.net.URL;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.client.ClientSessionManager;
import org.eclipse.osee.framework.core.client.server.HttpUrlBuilderClient;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.util.AbstractArtifactUrl;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.utility.OseeInfo;

public class ArtifactUrlClient
extends AbstractArtifactUrl {
    public Long getTransactionId(ArtifactToken artifact) {
        return ((Artifact)artifact).getTransaction().getId();
    }

    public boolean isUseConnectedServerUrl() {
        HttpUrlBuilderClient httpBuilder = HttpUrlBuilderClient.getInstance();
        return httpBuilder.isUseConnectedServerUrl();
    }

    public boolean isHistorical(ArtifactToken artifact) {
        return ((Artifact)artifact).isHistorical();
    }

    public boolean isDeleted(ArtifactToken artifact) {
        return ((Artifact)artifact).isDeleted();
    }

    public String getSessionId() {
        return ClientSessionManager.getSessionId();
    }

    public String getClientName() {
        return ClientSessionManager.getClientName();
    }

    public String getClientPort() {
        return ClientSessionManager.getClientPort();
    }

    URL getOpenInOseeLink(Artifact artifact, PresentationType presentationType) {
        return this.getOpenInOseeLink(artifact, "open.artifact", presentationType);
    }

    public String getPermanentBaseUrl() {
        String address = OseeInfo.getValue("osee.permanent.base.url");
        return this.normalize(address);
    }

    public String getAppServerPrefix() {
        HttpUrlBuilderClient httpBuilder = HttpUrlBuilderClient.getInstance();
        return httpBuilder.getApplicationServerPrefix();
    }

    public String getSelectedPermanentLinkUrl() {
        String address = null;
        if (this.isUseConnectedServerUrl()) {
            address = this.getAppServerPrefix();
        } else {
            try {
                address = this.getPermanentBaseUrl();
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.WARNING, (Throwable)ex);
            }
            if (!Strings.isValid((String)address)) {
                address = this.getAppServerPrefix();
            }
        }
        return this.normalize(address);
    }
}

