/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.access;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.OseeCodeVersion;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;

public class XResultDataHeaders {
    public static XResultData getXResultAccessHeader(String title, Artifact artifact, XResultData rd) {
        if (rd == null) {
            rd = new XResultData();
        }
        String release = XResultDataHeaders.getReleaseStr();
        rd.logf("%s\n\nArtifact: %s\nArifact Type %s\nBranch: %s\nUser: %s\nRelease: %s\n\n", new Object[]{title, artifact.toStringWithId(), artifact.getArtifactType().toStringWithId(), artifact.getBranch().toStringWithId(), UserManager.getUser().toStringWithId(), release});
        return rd;
    }

    public static XResultData getXResultAccessHeader(String title, Collection<? extends ArtifactToken> artifacts, AttributeTypeToken attributeType, XResultData rd) {
        if (rd == null) {
            rd = new XResultData();
        }
        String release = XResultDataHeaders.getReleaseStr();
        rd.logf("%s\n\nArtifact(s):\nAttrType: %s\nUser: %s\nRelease: %s\nBranch: %s\n\n", new Object[]{title, Artifacts.toStringWithIds(artifacts), attributeType, UserManager.getUser().toStringWithId(), release, artifacts.iterator().next().getBranch().toStringWithId()});
        return rd;
    }

    public static XResultData getXResultAccessHeader(String title, Collection<? extends ArtifactToken> artifacts, RelationTypeSide relTypeSide, XResultData rd) {
        if (rd == null) {
            rd = new XResultData();
        }
        String release = XResultDataHeaders.getReleaseStr();
        rd.logf("%s\n\nArtifact(s):\nRelType: %s\nUser: %s\nRelease: %s\nBranch: %s\n\n", new Object[]{title, Artifacts.toStringWithIds(artifacts), relTypeSide, UserManager.getUser().toStringWithId(), release, artifacts.iterator().next().getBranch().toStringWithId()});
        return rd;
    }

    public static XResultData getXResultAccessHeader(String title, BranchToken branch, XResultData rd) {
        if (rd == null) {
            rd = new XResultData();
        }
        String release = XResultDataHeaders.getReleaseStr();
        rd.logf("%s\n\nBranch: %s\nUser: %s\nRelease: %s\n\n", new Object[]{title, branch.toStringWithId(), UserManager.getUser().toStringWithId(), release});
        return rd;
    }

    public static XResultData getXResultAccessHeader(String title, Collection<? extends ArtifactToken> artifacts, XResultData rd) {
        return null;
    }

    private static String getReleaseStr() {
        String verStr = OseeCodeVersion.getVersion();
        String bundleVerStr = OseeCodeVersion.getBundleVersion();
        String release = verStr;
        if (!verStr.equals(bundleVerStr)) {
            release = String.format("%s / %s", verStr, bundleVerStr);
        }
        return release;
    }
}

