/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.relation.order;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.core.internal.relation.order.HasOrderData;
import org.eclipse.osee.orcs.core.internal.relation.order.OrderAccessor;
import org.eclipse.osee.orcs.core.internal.relation.order.OrderChange;
import org.eclipse.osee.orcs.core.internal.relation.order.OrderData;
import org.eclipse.osee.orcs.core.internal.relation.order.OrderEntryComparator;
import org.eclipse.osee.orcs.core.internal.relation.sorter.Sorter;
import org.eclipse.osee.orcs.core.internal.relation.sorter.SorterProvider;

public class OrderManager
implements HasOrderData {
    private static final OrderEntryComparator ENTRY_COMPARATOR = new OrderEntryComparator();
    private final Map<RelationTypeSide, OrderData> orderDataMap = new ConcurrentHashMap<RelationTypeSide, OrderData>();
    private final OrderAccessor accessor;
    private final SorterProvider sorterProvider;

    public OrderManager(SorterProvider sorterProvider, OrderAccessor accessor) {
        this.sorterProvider = sorterProvider;
        this.accessor = accessor;
    }

    @Override
    public void add(RelationTypeSide typeAndSide, OrderData data) {
        Conditions.checkNotNull((Object)typeAndSide, (String)"type and side key");
        Conditions.checkNotNull((Object)data, (String)"orderData");
        this.orderDataMap.put(typeAndSide, data);
    }

    @Override
    public void remove(RelationTypeSide typeAndSide) {
        Conditions.checkNotNull((Object)typeAndSide, (String)"type and side key");
        this.orderDataMap.remove(typeAndSide);
    }

    @Override
    public Iterator<Map.Entry<RelationTypeSide, OrderData>> iterator() {
        ArrayList<Map.Entry<RelationTypeSide, OrderData>> entries = new ArrayList<Map.Entry<RelationTypeSide, OrderData>>(this.orderDataMap.entrySet());
        Collections.sort(entries, ENTRY_COMPARATOR);
        return entries.iterator();
    }

    @Override
    public void clear() {
        this.orderDataMap.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.orderDataMap.isEmpty();
    }

    @Override
    public int size() {
        return this.orderDataMap.size();
    }

    public void load() {
        this.accessor.load(this);
    }

    public void store() {
        this.accessor.store(this, OrderChange.Forced);
    }

    public Collection<RelationTypeSide> getExistingTypes() {
        return this.orderDataMap.keySet();
    }

    private OrderData getOrderData(RelationTypeSide typeAndSide) {
        Conditions.checkNotNull((Object)typeAndSide, (String)"type and side key");
        return this.orderDataMap.get(typeAndSide);
    }

    public List<String> getOrderIds(RelationTypeSide typeAndSide) {
        Conditions.checkNotNull((Object)typeAndSide, (String)"type and side key");
        OrderData data = this.orderDataMap.get(typeAndSide);
        return data != null ? data.getOrderIds() : Collections.emptyList();
    }

    public RelationSorter getSorterId(RelationTypeSide typeAndSide) {
        Conditions.checkNotNull((Object)typeAndSide, (String)"type and side key");
        OrderData data = this.orderDataMap.get(typeAndSide);
        RelationSorter sorterId = null;
        sorterId = data != null ? data.getSorterId() : this.getDefaultSorterId((RelationTypeToken)typeAndSide);
        return sorterId;
    }

    private RelationSorter getDefaultSorterId(RelationTypeToken type) {
        return this.sorterProvider.getDefaultSorterId(type);
    }

    public void sort(RelationTypeSide typeAndSide, List<? extends ArtifactToken> listToOrder) {
        if (listToOrder.size() > 1) {
            RelationSorter sorterId = this.getSorterId(typeAndSide);
            List<String> relativeOrder = this.getOrderIds(typeAndSide);
            Sorter order = this.sorterProvider.getSorter(sorterId);
            order.sort(listToOrder, relativeOrder);
        }
    }

    public void setOrder(RelationTypeSide typeAndSide, List<? extends ArtifactToken> relativeSequence) {
        RelationSorter sorterId = this.getSorterId(typeAndSide);
        this.setOrder(typeAndSide, sorterId, relativeSequence);
    }

    public void setOrder(RelationTypeSide typeAndSide, RelationSorter sorterId, List<? extends ArtifactToken> relativeSequence) {
        List<String> sequence;
        if (!relativeSequence.isEmpty()) {
            sequence = new ArrayList();
            for (ArtifactToken artifactToken : relativeSequence) {
                sequence.add(artifactToken.getGuid());
            }
        } else {
            sequence = Collections.emptyList();
        }
        this.setAndStoreOrder(typeAndSide, sorterId, sequence);
    }

    private void setAndStoreOrder(RelationTypeSide typeAndSide, RelationSorter requestedSorterId, List<String> relativeSequence) {
        boolean isDifferentSorterId = this.isDifferentSorterId(typeAndSide, requestedSorterId);
        boolean changingRelatives = this.isRelativeOrderChange(typeAndSide, requestedSorterId, relativeSequence);
        OrderChange changeType = OrderChange.NoChange;
        if (isDifferentSorterId || changingRelatives) {
            if (isDifferentSorterId && this.isSetToDefaultSorter(typeAndSide, requestedSorterId)) {
                this.remove(typeAndSide);
                changeType = OrderChange.SetToDefault;
            } else {
                OrderData orderData = this.getOrderData(typeAndSide);
                if (orderData == null) {
                    orderData = new OrderData(requestedSorterId, relativeSequence);
                    this.add(typeAndSide, orderData);
                } else {
                    orderData.setSorterId(requestedSorterId);
                    orderData.setOrderIds(relativeSequence);
                }
                changeType = OrderChange.OrderRequest;
            }
        }
        this.accessor.store(this, changeType);
    }

    private boolean isDifferentSorterId(RelationTypeSide typeAndSide, RelationSorter newSorterId) {
        RelationSorter currentSorter = this.getSorterId(typeAndSide);
        return !currentSorter.equals((Object)newSorterId);
    }

    private boolean isSetToDefaultSorter(RelationTypeSide typeAndSide, RelationSorter sorterId) {
        RelationSorter defaultSorterId = this.getDefaultSorterId((RelationTypeToken)typeAndSide);
        return defaultSorterId.equals((Object)sorterId);
    }

    private boolean isRelativeOrderChange(RelationTypeSide typeAndSide, RelationSorter sorterId, List<String> relativeSequence) {
        boolean result = false;
        if (sorterId.equals((Object)RelationSorter.USER_DEFINED)) {
            List<String> currentOrder = this.getOrderIds(typeAndSide);
            result = !this.areSame(currentOrder, relativeSequence);
        }
        return result;
    }

    private boolean areSame(List<String> list1, List<String> list2) {
        boolean result;
        boolean bl = result = list1.size() == list2.size();
        if (result) {
            int index = 0;
            while (index < list1.size()) {
                String obj2;
                String obj1 = list1.get(index);
                if (!obj1.equals(obj2 = list2.get(index))) {
                    result = false;
                    break;
                }
                ++index;
            }
        }
        return result;
    }
}

