/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.messaging.internal.old;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.osee.framework.messaging.EndpointSend;
import org.eclipse.osee.framework.messaging.id.MessageId;
import org.eclipse.osee.framework.messaging.id.ProtocolId;

public class EndpointSendCollection {
    private final List<EndpointSend> endpoints = new CopyOnWriteArrayList<EndpointSend>();
    private final Map<ProtocolId, EndpointSend> protocolMapping = new ConcurrentHashMap<ProtocolId, EndpointSend>();
    private final Map<MessageId, ProtocolId> messageIdMapping = new ConcurrentHashMap<MessageId, ProtocolId>();

    public synchronized boolean add(EndpointSend endpoint) {
        if (this.endpoints.contains(endpoint)) {
            return false;
        }
        return this.endpoints.add(endpoint);
    }

    public synchronized boolean remove(EndpointSend endpoint) {
        if (this.endpoints.remove(endpoint)) {
            ArrayList<ProtocolId> protocolIdsToRemove = new ArrayList<ProtocolId>();
            Iterator<ProtocolId> it = this.protocolMapping.keySet().iterator();
            while (it.hasNext()) {
                ProtocolId id = it.next();
                if (!this.protocolMapping.get(id).equals(endpoint)) continue;
                it.remove();
                protocolIdsToRemove.add(id);
            }
            for (ProtocolId id : protocolIdsToRemove) {
                this.removeProtocolId(id);
            }
            return true;
        }
        return false;
    }

    public synchronized boolean bind(ProtocolId protocolId, EndpointSend endpoint) {
        if (this.protocolMapping.containsKey(protocolId)) {
            return false;
        }
        this.protocolMapping.put(protocolId, endpoint);
        return true;
    }

    public synchronized boolean unbind(ProtocolId protocolId, EndpointSend endpoint) {
        if (this.protocolMapping.containsKey(protocolId)) {
            this.protocolMapping.remove(protocolId);
            this.removeProtocolId(protocolId);
            return true;
        }
        return false;
    }

    private void removeProtocolId(ProtocolId protocolId) {
        Iterator<MessageId> it = this.messageIdMapping.keySet().iterator();
        while (it.hasNext()) {
            MessageId id = it.next();
            if (!this.messageIdMapping.get(id).equals(protocolId)) continue;
            it.remove();
        }
    }

    public synchronized boolean bind(MessageId messageId, ProtocolId protocolId) {
        if (this.messageIdMapping.containsKey(messageId)) {
            return false;
        }
        this.messageIdMapping.put(messageId, protocolId);
        return true;
    }

    public synchronized boolean unbind(MessageId messageId, ProtocolId protocolId) {
        if (this.messageIdMapping.containsKey(messageId)) {
            this.messageIdMapping.remove(messageId);
            return true;
        }
        return false;
    }

    public synchronized Collection<EndpointSend> getAll() {
        return this.endpoints;
    }

    public synchronized void dispose() {
        this.endpoints.clear();
        this.protocolMapping.clear();
        this.messageIdMapping.clear();
    }

    public synchronized EndpointSend get(MessageId id) {
        EndpointSend send;
        ProtocolId protocolId = this.messageIdMapping.get(id);
        if (protocolId != null && (send = this.protocolMapping.get(protocolId)) != null) {
            return send;
        }
        return null;
    }
}

