/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.define.operations;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ote.define.operations.AbstractRemoteResourceRequestTemplate;

public class RemoteResourceRequestOperation
extends AbstractRemoteResourceRequestTemplate {
    private static final String STORAGE_PATH = "TEMP";
    private final String fileName;

    public RemoteResourceRequestOperation(String tempFolderName, String remoteRequestUrl, String fileName) {
        super(STORAGE_PATH, remoteRequestUrl);
        this.fileName = fileName;
    }

    @Override
    protected String getLocalStorageName() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getTempFolderName());
        builder.append(File.separator);
        builder.append(this.fileName);
        return builder.toString();
    }

    @Override
    protected String getRemoteFileName() {
        return this.fileName;
    }

    @Override
    protected HttpURLConnection setupConnection(URL url) throws IOException {
        HttpURLConnection connection = super.setupConnection(url);
        connection.setAllowUserInteraction(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setInstanceFollowRedirects(true);
        return connection;
    }

    @Override
    protected IFile handleTransfer(IProgressMonitor monitor, HttpURLConnection connection) throws Exception {
        IFile file = null;
        try (InputStream stream = null;){
            int result = connection.getResponseCode();
            if (result == 200) {
                stream = (InputStream)connection.getContent();
                file = this.getLocalStorageIFile();
                file.create(stream, true, monitor);
                monitor.setTaskName("File Transfer Complete.");
            }
        }
        return file;
    }
}

