/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.importer;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osee.define.ide.internal.Activator;
import org.eclipse.osee.define.ide.traceability.TraceUnitExtensionManager;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.MutableBoolean;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.ui.plugin.util.DirectoryOrFileSelector;
import org.eclipse.osee.framework.ui.skynet.branch.BranchSelectComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.WizardDataTransferPage;

public class ImportTraceUnitPage
extends WizardDataTransferPage {
    private static final String PAGE_NAME = "org.eclipse.osee.define.ide.traceability.importer.importTraceUnitPage";
    private static final String PAGE_TITLE = "Import Trace Units into OSEE";
    private static final String PAGE_DESCRIPTION = "Imports trace units into OSEE and updates relations.";
    private static final String SOURCE_GROUP = "Select trace unit(s) source path";
    private static final String BRANCH_SELECT_GROUP = "Select branch to import into";
    private static final String IMPORT_BRANCH_TOOLTIP = "Only working branches are allowed";
    private static final String TRACE_UNIT_HANDLER_GROUP = "Select trace unit parser";
    private static final String TRACE_UNIT_ERROR = "Please select a trace unit handler";
    private static final String OPTIONS_GROUP = "Processing Options";
    private static final String PERSIST_CHANGES = "Persist Changes";
    private static final String PERSIST_TOOLTIP = "When not selected, will report all trace marks found per trace unit file.";
    private static final String RECURSION_BUTTON = "Traverse sub-folders";
    private static final String RECURSION_TOOLTIP = "When selected, processing will include folders and their sub-folders.";
    private static final String FILE_WITH_PATHS_BUTTON = "Is File With Embedded Paths";
    private static final String FILE_WITH_PATHS_TOOLTIP = "Select when using a source file with multiple paths separated with newlines.";
    private static final String ADD_GUID_TO_SOURCE_FILE_BUTTON = "Add GUID to Source";
    private static final String ADD_GUID_TO_SOURCE_FILE_TOOLTIP = "When selected, the GUID will be added to the source file. Note: You will need write access to the files to use this selection.";
    private static final String INCLUDE_IMPD_BUTTON = "Include IMPD";
    private static final String INCLUDE_IMPD_TOOLTIP = "Select to include IMPD trace marks.";
    private static final String SELECTED_TRACE_HANDLERS_KEY = "trace.handlers";
    private static final String BRANCH_KEY = "branch.selected";
    private static final String SOURCE_URI_KEY = "source.uri";
    private static final String SOURCE_URI_IS_DIRECTORY_KEY = "source.uri.is.directory";
    private static final String IS_ART_PERSIST_ALLOWED_KEY = "is.art.persist.allowed";
    private static final String IS_FOLDER_RECURSION_KEY = "is.folder.recurse.allowed";
    private static final String IS_FILE_WITH_MULTI_PATHS_KEY = "is.file.with.multi.paths";
    private static final String IS_ADD_GUID_TO_SOURCE_KEY = "is.add.guid.to.source";
    private static final String INCLUDE_IMPD_KEY = "is.impd.included";
    private DirectoryOrFileSelector directoryFileSelector;
    private BranchSelectComposite branchSelectComposite;
    private final MutableBoolean isFolderRecursionAllowed;
    private final MutableBoolean isArtifactPersistanceAllowed;
    private List<IResource> currentResourceSelection;
    private final MutableBoolean isFileContainingMultiplePaths;
    private final MutableBoolean isAddGuidToSourceFileAllowed;
    private final Map<Button, Boolean> traceUnitHandlers;
    private final Map<String, Button> optionButtons;
    private final MutableBoolean isImpdIncluded;

    public ImportTraceUnitPage(IStructuredSelection selection) {
        super(PAGE_NAME);
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESCRIPTION);
        this.traceUnitHandlers = new HashMap<Button, Boolean>();
        this.optionButtons = new HashMap<String, Button>();
        this.isFolderRecursionAllowed = new MutableBoolean(false);
        this.isArtifactPersistanceAllowed = new MutableBoolean(false);
        this.isFileContainingMultiplePaths = new MutableBoolean(false);
        this.isAddGuidToSourceFileAllowed = new MutableBoolean(true);
        this.isImpdIncluded = new MutableBoolean(false);
        if (selection != null && selection.size() >= 1) {
            this.currentResourceSelection = new LinkedList<IResource>();
            for (Object element : selection) {
                IResource toAdd;
                if (!(element instanceof IAdaptable) || (toAdd = (IResource)((IAdaptable)element).getAdapter(IResource.class)) == null) continue;
                this.currentResourceSelection.add(toAdd);
            }
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        composite.setFont(parent.getFont());
        this.createTestUnitSourceArea(composite);
        this.createBranchSelectArea(composite);
        this.createParserSelectArea(composite);
        this.createOptionsArea(composite);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setControl((Control)composite);
        this.setPageComplete(this.determinePageCompletion());
        this.directoryFileSelector.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Button button = ImportTraceUnitPage.this.optionButtons.get(ImportTraceUnitPage.IS_FILE_WITH_MULTI_PATHS_KEY);
                if (ImportTraceUnitPage.this.isWidgetAccessible((Widget)button) && ImportTraceUnitPage.this.isWidgetAccessible((Widget)ImportTraceUnitPage.this.directoryFileSelector)) {
                    button.setEnabled(!ImportTraceUnitPage.this.directoryFileSelector.isDirectorySelected());
                }
                ImportTraceUnitPage.this.setPageComplete(ImportTraceUnitPage.this.determinePageCompletion());
            }
        });
    }

    private boolean isWidgetAccessible(Widget widget) {
        return widget != null && !widget.isDisposed();
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.determinePageCompletion());
    }

    protected void createTestUnitSourceArea(Composite parent) {
        this.directoryFileSelector = new DirectoryOrFileSelector(parent, 0, SOURCE_GROUP, (Listener)this, true);
        this.updateDirectoryFileSelection();
    }

    private void updateDirectoryFileSelection() {
        this.directoryFileSelector.setDirectorySelected(true);
        if (this.currentResourceSelection != null) {
            String text = null;
            if (!this.currentResourceSelection.isEmpty()) {
                IResource selected = this.currentResourceSelection.iterator().next();
                this.directoryFileSelector.setDirectorySelected(selected.getType() != 1);
                text = selected.getLocation().toString();
            } else {
                this.directoryFileSelector.setDirectorySelected(false);
                StringBuilder sb = new StringBuilder();
                for (IResource resource : this.currentResourceSelection) {
                    sb.append(resource.getLocation().toString());
                    sb.append(",");
                }
                if (sb.length() > 0) {
                    sb.setLength(sb.length() - ",".length());
                    text = sb.toString();
                }
            }
            if (Strings.isValid((String)text)) {
                this.directoryFileSelector.setText(text);
            }
        }
    }

    protected void createBranchSelectArea(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText(BRANCH_SELECT_GROUP);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        composite.setToolTipText(IMPORT_BRANCH_TOOLTIP);
        this.branchSelectComposite = new BranchSelectComposite((Composite)composite, 2048, true);
        this.branchSelectComposite.setToolTipText(IMPORT_BRANCH_TOOLTIP);
        this.branchSelectComposite.addListener(new Listener(){

            public void handleEvent(Event event) {
                ImportTraceUnitPage.this.setPageComplete(ImportTraceUnitPage.this.determinePageCompletion());
            }
        });
    }

    protected void createParserSelectArea(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText(TRACE_UNIT_HANDLER_GROUP);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        try {
            for (TraceUnitExtensionManager.TraceHandler handler : TraceUnitExtensionManager.getInstance().getAllTraceHandlers()) {
                this.createTraceHandler((Composite)composite, handler.getName(), handler.getId());
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    private void createTraceHandler(Composite parent, String text, String handlerId) {
        Button handlerButton = new Button(parent, 32);
        handlerButton.setText(text);
        handlerButton.setData((Object)handlerId);
        handlerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object source = e.getSource();
                if (source instanceof Button) {
                    Button button = (Button)source;
                    ImportTraceUnitPage.this.traceUnitHandlers.put(button, button.getSelection());
                }
                ImportTraceUnitPage.this.setPageComplete(ImportTraceUnitPage.this.determinePageCompletion());
            }
        });
        this.traceUnitHandlers.put(handlerButton, false);
    }

    protected void createOptionsArea(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText(OPTIONS_GROUP);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        this.createOptionButton((Composite)composite, IS_ART_PERSIST_ALLOWED_KEY, PERSIST_CHANGES, PERSIST_TOOLTIP, this.isArtifactPersistanceAllowed);
        this.createOptionButton((Composite)composite, IS_FOLDER_RECURSION_KEY, RECURSION_BUTTON, RECURSION_TOOLTIP, this.isFolderRecursionAllowed);
        this.createOptionButton((Composite)composite, IS_FILE_WITH_MULTI_PATHS_KEY, FILE_WITH_PATHS_BUTTON, FILE_WITH_PATHS_TOOLTIP, this.isFileContainingMultiplePaths);
        this.createOptionButton((Composite)composite, IS_ADD_GUID_TO_SOURCE_KEY, ADD_GUID_TO_SOURCE_FILE_BUTTON, ADD_GUID_TO_SOURCE_FILE_TOOLTIP, this.isAddGuidToSourceFileAllowed);
        this.createOptionButton((Composite)composite, INCLUDE_IMPD_KEY, INCLUDE_IMPD_BUTTON, INCLUDE_IMPD_TOOLTIP, this.isImpdIncluded);
    }

    private void createOptionButton(Composite parent, String buttonId, String buttonText, String buttonToolTip, final MutableBoolean toModify) {
        Button optionButton = new Button(parent, 32);
        optionButton.setText(buttonText);
        optionButton.setToolTipText(buttonToolTip);
        optionButton.setData((Object)toModify);
        optionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = e.getSource();
                if (object instanceof Button) {
                    toModify.setValue(((Button)object).getSelection());
                }
                ImportTraceUnitPage.this.setPageComplete(ImportTraceUnitPage.this.determinePageCompletion());
            }
        });
        optionButton.setSelection(toModify.getValue());
        this.optionButtons.put(buttonId, optionButton);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setErrorMessage(null);
        }
    }

    protected boolean validateSourceGroup() {
        BranchId branch;
        boolean result = this.directoryFileSelector.validate((WizardDataTransferPage)this);
        if (result && (branch = this.getSelectedBranch()) == null) {
            result = false;
            this.setErrorMessage("Please select a valid working branch");
        }
        if (result) {
            result &= this.validateParser(this);
        }
        return result;
    }

    protected boolean validateParser(WizardDataTransferPage wizardPage) {
        boolean result = false;
        String[] selectedHandlers = this.getTraceUnitHandlerIds();
        if (selectedHandlers.length > 0) {
            result = true;
        } else {
            wizardPage.setErrorMessage(TRACE_UNIT_ERROR);
        }
        return result;
    }

    public Iterable<URI> getSourceURI() {
        LinkedList<URI> toReturn = null;
        if (this.isWidgetAccessible((Widget)this.directoryFileSelector)) {
            toReturn = new LinkedList<URI>();
            if (this.directoryFileSelector.getSelection() != null) {
                for (File file : this.directoryFileSelector.getSelection()) {
                    toReturn.add(file.toURI());
                }
            }
        }
        return toReturn;
    }

    public BranchId getSelectedBranch() {
        return this.isWidgetAccessible((Widget)this.branchSelectComposite) ? this.branchSelectComposite.getSelectedBranch() : null;
    }

    public boolean isFolderRecursionAllowed() {
        return this.isFolderRecursionAllowed.getValue();
    }

    public boolean isArtifactPersistanceAllowed() {
        return this.isArtifactPersistanceAllowed.getValue();
    }

    public boolean isFileContainingMultiplePaths() {
        return this.isWidgetAccessible((Widget)this.directoryFileSelector) ? !this.directoryFileSelector.isDirectorySelected() && this.isFileContainingMultiplePaths.getValue() : this.isFileContainingMultiplePaths.getValue();
    }

    public boolean isAddGuidToSourceFileAllowed() {
        return this.isAddGuidToSourceFileAllowed.getValue();
    }

    public boolean isImpdIncluded() {
        return this.isImpdIncluded.getValue();
    }

    public String[] getTraceUnitHandlerIds() {
        ArrayList<String> selectedIds = new ArrayList<String>();
        for (Button button : this.traceUnitHandlers.keySet()) {
            Boolean value = this.traceUnitHandlers.get(button);
            if (value == null || !value.booleanValue()) continue;
            selectedIds.add((String)button.getData());
        }
        return selectedIds.toArray(new String[selectedIds.size()]);
    }

    protected void restoreWidgetValues() {
        super.restoreWidgetValues();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] traceHandlers;
            Object data;
            String source = settings.get(SOURCE_URI_KEY);
            if (Strings.isValid((String)source)) {
                this.directoryFileSelector.setDirectorySelected(settings.getBoolean(SOURCE_URI_IS_DIRECTORY_KEY));
                this.directoryFileSelector.setText(source);
            }
            for (String id : this.optionButtons.keySet()) {
                Boolean value = settings.getBoolean(id);
                if (id.equals(IS_FILE_WITH_MULTI_PATHS_KEY) && this.directoryFileSelector.isDirectorySelected()) {
                    value = false;
                }
                Button button = this.optionButtons.get(id);
                button.setSelection(value.booleanValue());
                data = button.getData();
                if (!(data instanceof MutableBoolean)) continue;
                ((MutableBoolean)data).setValue(value.booleanValue());
            }
            try {
                Long branchId = settings.getLong(BRANCH_KEY);
                if (branchId > 0L) {
                    this.branchSelectComposite.setSelected(BranchManager.getBranchToken((Long)branchId));
                }
            }
            catch (Exception exception) {}
            if ((traceHandlers = settings.getArray(SELECTED_TRACE_HANDLERS_KEY)) != null && traceHandlers.length > 0) {
                HashSet<String> traceIds = new HashSet<String>(Arrays.asList(traceHandlers));
                for (Button button : this.traceUnitHandlers.keySet()) {
                    String id;
                    data = button.getData();
                    if (!(data instanceof String) || !traceIds.contains(id = (String)data)) continue;
                    button.setSelection(true);
                    this.traceUnitHandlers.put(button, true);
                }
            }
        }
    }

    protected void saveWidgetValues() {
        super.saveWidgetValues();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            BranchId branch = this.getSelectedBranch();
            if (branch != null) {
                try {
                    settings.put(BRANCH_KEY, branch.getId().longValue());
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
            if (this.isWidgetAccessible((Widget)this.directoryFileSelector)) {
                settings.put(SOURCE_URI_KEY, this.directoryFileSelector.getText());
            }
            settings.put(SELECTED_TRACE_HANDLERS_KEY, this.getTraceUnitHandlerIds());
            settings.put(SOURCE_URI_IS_DIRECTORY_KEY, this.directoryFileSelector.isDirectorySelected());
            settings.put(IS_ART_PERSIST_ALLOWED_KEY, this.isArtifactPersistanceAllowed());
            settings.put(IS_FOLDER_RECURSION_KEY, this.isFolderRecursionAllowed());
            settings.put(IS_FILE_WITH_MULTI_PATHS_KEY, this.isFileContainingMultiplePaths());
            settings.put(IS_ADD_GUID_TO_SOURCE_KEY, this.isAddGuidToSourceFileAllowed());
            settings.put(INCLUDE_IMPD_KEY, this.isImpdIncluded());
        }
    }

    protected boolean allowNewContainerName() {
        return false;
    }
}

