/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.blam;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.define.ide.traceability.TestUnitTagger;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Image;

public class AddTraceMarksToTraceUnits
extends AbstractBlam {
    private static final Pattern commentPattern = Pattern.compile("/\\*\\s*\\*\\s*SCRIPT TRACEABILITY.*?\\*/", 32);

    public String getName() {
        return "Add Trace Marks to Resource";
    }

    public String getDescriptionUsage() {
        return "Adds trace marks to files selected.\n*** WARNING_OVERLAY: When \"Persist Changes\" is selected, files will be modified in place.\n There is no way to undo this operation - make sure you know what you are doing. ***\n ";
    }

    public String getXWidgetsXml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<xWidgets>");
        builder.append("<XWidget xwidgetType=\"XLabel\" displayName=\"Select File Or Folder (file can have a list of folders separated by newlines)\"/>");
        builder.append("<XWidget xwidgetType=\"XFileSelectionDialog\" displayName=\"Select File\" />");
        builder.append("<XWidget xwidgetType=\"XDirectorySelectionDialog\" displayName=\"Select Folder\" />");
        builder.append("<XWidget xwidgetType=\"XLabel\" displayName=\"Select Trace Types:\"/>");
        builder.append("<XWidget xwidgetType=\"XCheckBox\" displayName=\"Include Sub-Folders\" labelAfter=\"true\" horizontalLabel=\"true\" />");
        builder.append("<XWidget xwidgetType=\"XBranchSelectWidget\" displayName=\"Requirements Branch\" toolTip=\"Select a requirements branch.\" />");
        builder.append("</xWidgets>");
        return builder.toString();
    }

    private void checkPath(String filePath, String type) {
        if (!Strings.isValid((String)filePath)) {
            throw new OseeArgumentException("Please enter a valid %s path", new Object[]{type});
        }
        File file = new File(filePath);
        if (!file.exists()) {
            throw new OseeArgumentException("%s path [%s] is not accessible", new Object[]{type, filePath});
        }
    }

    private URI getSourceURI(VariableMap variableMap) {
        String filePath = variableMap.getString("Select File");
        String folderPath = variableMap.getString("Select Folder");
        String pathToUse = null;
        if (Strings.isValid((String)folderPath) && Strings.isValid((String)filePath)) {
            throw new OseeArgumentException("Enter file or folder but not both", new Object[0]);
        }
        if (Strings.isValid((String)folderPath)) {
            this.checkPath(folderPath, "folder");
            pathToUse = folderPath;
        } else {
            this.checkPath(filePath, "file");
            pathToUse = filePath;
        }
        return new File(pathToUse).toURI();
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        try {
            List<File> files;
            URI source = this.getSourceURI(variableMap);
            boolean isRecursionAllowed = variableMap.getBoolean("Include Sub-Folders");
            BranchId requirementsBranch = variableMap.getBranch("Requirements Branch");
            monitor.beginTask(this.getName(), Integer.MAX_VALUE);
            File sourceFile = new File(source.getPath());
            if (sourceFile.isDirectory()) {
                if (isRecursionAllowed) {
                    files = Lib.recursivelyListFiles((File)new File(source.getPath()), (Pattern)Pattern.compile(".+\\.java"));
                } else {
                    File[] f = sourceFile.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.getName().endsWith(".java");
                        }
                    });
                    if (f == null) {
                        throw new RuntimeException("listFiles() returns null");
                    }
                    files = Arrays.asList(f);
                }
            } else {
                files = Collections.singletonList(sourceFile);
            }
            this.processFiles(files, requirementsBranch);
        }
        finally {
            monitor.done();
        }
    }

    private void processFiles(List<File> files, BranchId branch) {
        Matcher matcher = TestUnitTagger.ANNOTATION_PATTERN.matcher("");
        for (File file : files) {
            ChangeSet change;
            String contents;
            String guid = null;
            try {
                guid = TestUnitTagger.getInstance().getSourceTag(file.toURI());
            }
            catch (Exception exception) {
                this.logf("Error reading guid from %s", new Object[]{file.getName()});
                continue;
            }
            if (!GUID.isValid((String)guid)) continue;
            Artifact testCase = ArtifactQuery.getArtifactFromId((String)guid, (BranchId)branch);
            List uses = testCase.getRelatedArtifacts(CoreRelationTypes.Uses_Requirement);
            List verifies = testCase.getRelatedArtifacts(CoreRelationTypes.Verification_Requirement);
            StringBuilder sb = new StringBuilder();
            for (Artifact art : verifies) {
                sb.append(" * Verifies: ");
                sb.append(art.getName());
                sb.append("\n");
            }
            for (Artifact art : uses) {
                sb.append(" * Uses: ");
                sb.append(art.getName());
                sb.append("\n");
            }
            if (sb.length() <= 0) continue;
            Matcher commentMatcher = commentPattern.matcher("");
            sb.insert(0, "/*\n * SCRIPT TRACEABILITY:\n *\n");
            sb.append(" */\n");
            try {
                contents = Lib.fileToString((File)file);
            }
            catch (IOException iOException) {
                this.logf("Error reading contents from %s", new Object[]{file.getName()});
                continue;
            }
            commentMatcher.reset(contents);
            matcher.reset(contents);
            String modified = null;
            if (commentMatcher.find()) {
                change = new ChangeSet((CharSequence)contents);
                change.replace(commentMatcher.start(), commentMatcher.end(), sb.toString());
                modified = change.applyChangesToSelf().toString();
            } else if (matcher.find()) {
                change = new ChangeSet((CharSequence)contents);
                change.insertBefore(matcher.start(), sb.toString());
                modified = change.applyChangesToSelf().toString();
            }
            if (modified == null) continue;
            try {
                Lib.writeStringToFile(modified, (File)file);
            }
            catch (IOException iOException) {
                this.logf("Error writing changes to %s", new Object[]{file.getName()});
            }
        }
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavigateItem.TRACE);
    }

    public Image getImage() {
        return ImageManager.getImage((KeyedImage)FrameworkImage.TRACE);
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.TRACE);
    }
}

