/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osee.define.ide.traceability.ITraceParser;
import org.eclipse.osee.define.ide.traceability.ITraceUnitResourceLocator;
import org.eclipse.osee.framework.jdk.core.type.Named;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.plugin.core.util.ExtensionPoints;
import org.osgi.framework.Bundle;

public class TraceUnitExtensionManager {
    private static final String TRACE_UNIT_HANDLER = "TraceUnitHandler";
    private static final String TRACE_UNIT_RESOURCE_LOCATOR = "TraceUnitResourceLocator";
    private static final String TRACE_UNIT_PARSER = "TraceUnitParser";
    private final Map<String, TraceHandler> contributions = new HashMap<String, TraceHandler>();
    private static TraceUnitExtensionManager instance = null;

    private TraceUnitExtensionManager() {
    }

    public static TraceUnitExtensionManager getInstance() {
        if (instance == null) {
            instance = new TraceUnitExtensionManager();
        }
        return instance;
    }

    public Set<String> getTraceUnitHandlerIds() {
        this.checkObjectsLoaded();
        return this.contributions.keySet();
    }

    public Collection<TraceHandler> getAllTraceHandlers() {
        this.checkObjectsLoaded();
        return this.contributions.values();
    }

    public TraceHandler getTraceUnitHandlerById(String id) {
        this.checkObjectsLoaded();
        return this.contributions.get(id);
    }

    public TraceHandler getTraceHandlerByName(String name) {
        this.checkObjectsLoaded();
        TraceHandler toReturn = null;
        for (TraceHandler handler : this.getAllTraceHandlers()) {
            if (!handler.getName().equals(name)) continue;
            toReturn = handler;
            break;
        }
        return toReturn;
    }

    public ITraceParser getTraceParserById(String id) {
        TraceHandler traceUnitHandler = this.getTraceUnitHandlerById(id);
        if (traceUnitHandler != null) {
            return traceUnitHandler.getParser();
        }
        return null;
    }

    public ITraceUnitResourceLocator getTraceUnitLocatorById(String id) {
        TraceHandler traceUnitHandler = this.getTraceUnitHandlerById(id);
        if (traceUnitHandler != null) {
            return traceUnitHandler.getLocator();
        }
        return null;
    }

    public List<String> getAllTraceHandlerNames() {
        return Named.getNames(this.getAllTraceHandlers());
    }

    public Collection<ITraceParser> getAllTraceParsers() {
        this.checkObjectsLoaded();
        HashSet<ITraceParser> parsers = new HashSet<ITraceParser>();
        for (TraceHandler traceHandler : this.contributions.values()) {
            ITraceParser parser = traceHandler.getParser();
            if (parser == null) continue;
            parsers.add(parser);
        }
        return parsers;
    }

    public Set<ITraceUnitResourceLocator> getAllTraceUnitLocators() {
        this.checkObjectsLoaded();
        HashSet<ITraceUnitResourceLocator> locators = new HashSet<ITraceUnitResourceLocator>();
        for (TraceHandler traceHandler : this.contributions.values()) {
            ITraceUnitResourceLocator locator = traceHandler.getLocator();
            if (locator == null) continue;
            locators.add(locator);
        }
        return locators;
    }

    private void checkObjectsLoaded() {
        if (this.contributions.isEmpty()) {
            List elements = ExtensionPoints.getExtensionElements((String)"org.eclipse.osee.define.ide.TraceUnitHandler", (String)TRACE_UNIT_HANDLER);
            for (IConfigurationElement element : elements) {
                IExtension extension = (IExtension)element.getParent();
                String identifier = extension.getUniqueIdentifier();
                String name = extension.getLabel();
                String bundleName = element.getContributor().getName();
                String parserClassName = element.getAttribute(TRACE_UNIT_PARSER);
                String locatorClassName = element.getAttribute(TRACE_UNIT_RESOURCE_LOCATOR);
                ITraceParser parser = (ITraceParser)this.loadClass(bundleName, parserClassName);
                ITraceUnitResourceLocator locator = (ITraceUnitResourceLocator)this.loadClass(bundleName, locatorClassName);
                if (parser == null || locator == null) continue;
                this.contributions.put(identifier, new TraceHandler(identifier, name, locator, parser));
            }
        }
    }

    private Object loadClass(String bundleName, String className) {
        Object object = null;
        if (Strings.isValid((String)bundleName) && Strings.isValid((String)className)) {
            try {
                Bundle bundle = Platform.getBundle((String)bundleName);
                Class taskClass = bundle.loadClass(className);
                try {
                    Method getInstance = taskClass.getMethod("getInstance", new Class[0]);
                    object = getInstance.invoke(null, new Object[0]);
                }
                catch (Exception exception) {
                    object = taskClass.newInstance();
                }
            }
            catch (Exception ex) {
                throw new OseeCoreException(String.format("Unable to Load: [%s - %s]", bundleName, className), (Throwable)ex);
            }
        }
        return object;
    }

    public static final class TraceHandler
    implements Named {
        private final String name;
        private final String id;
        private final ITraceUnitResourceLocator locator;
        private final ITraceParser parser;

        private TraceHandler(String id, String name, ITraceUnitResourceLocator locator, ITraceParser parser) {
            this.name = name;
            this.id = id;
            this.locator = locator;
            this.parser = parser;
        }

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }

        public ITraceUnitResourceLocator getLocator() {
            return this.locator;
        }

        public ITraceParser getParser() {
            return this.parser;
        }
    }
}

