/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.blam.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.result.Manipulations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.relation.RelationManager;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;

public class RequirementsTestReport
extends AbstractBlam {
    private static final String MISSING = "?";
    private static final String EMPTY = "&nbsp;";
    private static final String SPACE = " ";
    private String[] previousCells = new String[]{"?", "?", "?", "?"};
    private final String[] columnHeaders = new String[]{"Requirement", "Test Procedure(s)", "Test Status", "Result File(s)"};
    private Collection<Artifact> inputArtifacts;
    private Collection<Artifact> requirementsBulkLoad;
    private StringBuilder report;

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        this.init(variableMap);
        for (Artifact input : this.inputArtifacts) {
            this.processArtifacts(input);
        }
        this.report();
    }

    private void processArtifacts(Artifact node) throws IOException {
        List children = node.getChildren();
        if (node.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.Requirement})) {
            this.processRequirement(node);
        } else {
            this.reportLine(this.getReqCellOutput(node), "N/A (" + node.getArtifactTypeName() + ")", EMPTY, EMPTY);
        }
        for (Artifact child : children) {
            this.processArtifacts(child);
        }
    }

    private void processRequirement(Artifact req) {
        List testProcs = req.getRelatedArtifacts(CoreRelationTypes.Verification_Verifier);
        if (testProcs.isEmpty()) {
            this.reportLine(this.getReqCellOutput(req), MISSING, MISSING, MISSING);
        } else {
            for (Artifact testProc : testProcs) {
                this.processTestProcedure(req, testProc);
            }
        }
    }

    private void processTestProcedure(Artifact req, Artifact testProc) {
        String testStatus = testProc.isAttributeTypeValid((AttributeTypeId)CoreAttributeTypes.TestProcedureStatus) ? (String)testProc.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.TestProcedureStatus, (Object)MISSING) : "N/A (" + testProc.getArtifactTypeName() + ")";
        List resultFiles = testProc.getRelatedArtifacts(CoreRelationTypes.ResultsData_TestResult);
        if (resultFiles.isEmpty()) {
            this.reportLine(this.getReqCellOutput(req), testProc.getName(), testStatus, MISSING);
        } else {
            for (Artifact resultFile : resultFiles) {
                this.reportLine(this.getReqCellOutput(req), testProc.getName(), testStatus, resultFile.getName());
            }
        }
    }

    private String getReqCellOutput(Artifact req) {
        String paragraphNumber = (String)req.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, (Object)"");
        String reqName = req.getName();
        String returnValue = String.valueOf(paragraphNumber) + SPACE + reqName;
        return returnValue;
    }

    private void reportLine(String ... cells) {
        String[] outputCells = new String[4];
        int i = 0;
        while (i < cells.length) {
            outputCells[i] = this.previousCells[i].equals(cells[i]) ? (i == 0 || outputCells[i - 1].equals(SPACE) ? SPACE : cells[i]) : cells[i];
            ++i;
        }
        this.previousCells = (String[])cells.clone();
        this.report.append(AHTML.addRowMultiColumnTable((String[])outputCells));
    }

    private void report() {
        this.report.append(AHTML.endMultiColumnTable());
        XResultData rd = new XResultData();
        rd.addRaw(this.report.toString());
        XResultDataUI.report((XResultData)rd, (String)"Requirements Test Report", (Manipulations[])new Manipulations[]{Manipulations.RAW_HTML});
    }

    private void init(VariableMap variableMap) {
        this.inputArtifacts = variableMap.getArtifacts("artifacts");
        this.initReport();
        this.load();
    }

    private void initReport() {
        this.report = new StringBuilder(AHTML.beginMultiColumnTable((int)100, (int)1));
        this.report.append(AHTML.addHeaderRowMultiColumnTable((String[])this.columnHeaders));
    }

    private void load() {
        this.requirementsBulkLoad = new ArrayList<Artifact>();
        for (Artifact input : this.inputArtifacts) {
            this.requirementsBulkLoad.addAll(input.getDescendants());
        }
        Set temp = RelationManager.getRelatedArtifacts(this.requirementsBulkLoad, (int)1, (RelationTypeSide[])new RelationTypeSide[]{CoreRelationTypes.Verification_Verifier});
        Set temp2 = RelationManager.getRelatedArtifacts((Collection)temp, (int)1, (RelationTypeSide[])new RelationTypeSide[]{CoreRelationTypes.ResultsData_TestResult});
        this.logf("Bulk loaded %d test results", new Object[]{temp2.size()});
    }

    public String getXWidgetsXml() {
        return "<xWidgets><XWidget xwidgetType=\"XListDropViewer\" displayName=\"artifacts\" /></xWidgets>";
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavigateItem.DEFINE);
    }

    public String getName() {
        return "Requirements Test Report";
    }
}

