/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.messaging.event.res.internal;

import java.util.HashMap;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.messaging.ConnectionListener;
import org.eclipse.osee.framework.messaging.MessageService;
import org.eclipse.osee.framework.messaging.event.res.IFrameworkEventListener;
import org.eclipse.osee.framework.messaging.event.res.IOseeCoreModelEventService;
import org.eclipse.osee.framework.messaging.event.res.RemoteEvent;
import org.eclipse.osee.framework.messaging.event.res.internal.OseeCoreModelEventServiceImpl;
import org.eclipse.osee.framework.messaging.event.res.internal.ResMessages;

public class OseeCoreModelEventServiceProxy
implements IOseeCoreModelEventService {
    private MessageService messageService;
    private IOseeCoreModelEventService proxiedService;

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    private IOseeCoreModelEventService getProxiedService() {
        return this.proxiedService;
    }

    public void start() {
        HashMap<ResMessages, Boolean> eventMessageConfig = new HashMap<ResMessages, Boolean>();
        eventMessageConfig.put(ResMessages.RemoteBranchEvent1, Boolean.TRUE);
        eventMessageConfig.put(ResMessages.RemoteBroadcastEvent1, Boolean.TRUE);
        eventMessageConfig.put(ResMessages.RemotePersistEvent1, Boolean.FALSE);
        eventMessageConfig.put(ResMessages.RemoteTopicEvent1, Boolean.FALSE);
        eventMessageConfig.put(ResMessages.RemoteTransactionEvent1, Boolean.TRUE);
        eventMessageConfig.put(ResMessages.RemoteTopicArtifactEvent, Boolean.TRUE);
        this.proxiedService = new OseeCoreModelEventServiceImpl(this.messageService, eventMessageConfig);
    }

    public void stop() {
        this.proxiedService = null;
    }

    private void checkInitialized() {
        Conditions.checkNotNull((Object)this.getProxiedService(), (String)"IOseeCoreModelEventService was not initialized correctly. Make sure start() was called");
    }

    @Override
    public void addFrameworkListener(IFrameworkEventListener frameworkEventListener) {
        this.checkInitialized();
        this.getProxiedService().addFrameworkListener(frameworkEventListener);
    }

    @Override
    public void removeFrameworkListener(IFrameworkEventListener frameworkEventListener) {
        this.checkInitialized();
        this.getProxiedService().removeFrameworkListener(frameworkEventListener);
    }

    @Override
    public void addConnectionListener(ConnectionListener connectionListener) {
        this.checkInitialized();
        this.getProxiedService().addConnectionListener(connectionListener);
    }

    @Override
    public void removeConnectionListener(ConnectionListener connectionListener) {
        this.checkInitialized();
        this.getProxiedService().removeConnectionListener(connectionListener);
    }

    @Override
    public void sendRemoteEvent(RemoteEvent remoteEvent) {
        this.checkInitialized();
        this.getProxiedService().sendRemoteEvent(remoteEvent);
    }
}

