/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.world.WorldComposite;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.ats.ide.world.WorldEditorSimpleProvider;
import org.eclipse.osee.ats.ide.world.WorldEditorUISearchItemProvider;
import org.eclipse.osee.ats.ide.world.search.GroupWorldSearchItem;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactData;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.skynet.artifact.ArtifactTransfer;
import org.eclipse.osee.framework.ui.skynet.util.SkynetDragAndDrop;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Control;

public class WorldViewDragAndDrop
extends SkynetDragAndDrop {
    private final WorldComposite worldComposite;

    public WorldViewDragAndDrop(WorldComposite worldComposite, String viewId) {
        super((Control)worldComposite.getXViewer().getTree(), viewId);
        this.worldComposite = worldComposite;
    }

    public Artifact[] getArtifacts() {
        IStructuredSelection selection = (IStructuredSelection)this.worldComposite.getXViewer().getSelection();
        Iterator i = selection.iterator();
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        while (i.hasNext()) {
            Object object = i.next();
            if (!(object instanceof Artifact)) continue;
            artifacts.add(AtsApiService.get().getQueryServiceIde().getArtifact(object));
        }
        return artifacts.toArray(new Artifact[artifacts.size()]);
    }

    protected boolean isValidForArtifactDrop(DropTargetEvent event) {
        ArtifactData artData;
        boolean validForDrop = false;
        if (ArtifactTransfer.getInstance().isSupportedType(event.currentDataType) && (artData = ArtifactTransfer.getInstance().nativeToJava(event.currentDataType)) != null) {
            Artifact[] artifacts;
            Artifact[] artifactArray = artifacts = artData.getArtifacts();
            int n = artifacts.length;
            int n2 = 0;
            while (n2 < n) {
                Artifact art = artifactArray[n2];
                if (AtsObjects.isAtsWorkItemOrAction((Object)art) || art.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.UniversalGroup})) {
                    validForDrop = true;
                    break;
                }
                ++n2;
            }
        }
        return validForDrop;
    }

    public void performDragOver(DropTargetEvent event) {
        if (this.isValidForArtifactDrop(event)) {
            event.detail = 1;
        }
    }

    public void performDrop(DropTargetEvent event) {
        if (ArtifactTransfer.getInstance().isSupportedType(event.currentDataType)) {
            final ArtifactData artData = ArtifactTransfer.getInstance().nativeToJava(event.currentDataType);
            Job job = new Job("Loading WorldView..."){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        String name = "Dropped Artifacts";
                        HashSet<Artifact> arts = new HashSet<Artifact>();
                        if (artData != null) {
                            Artifact art;
                            Artifact[] artifacts = artData.getArtifacts();
                            if (artifacts.length == 1) {
                                art = artifacts[0];
                                if (AtsObjects.isAtsWorkItemOrAction((Object)art)) {
                                    name = art.getName();
                                } else if (art.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.UniversalGroup})) {
                                    GroupWorldSearchItem groupWorldSearchItem = new GroupWorldSearchItem((BranchId)art.getBranch());
                                    groupWorldSearchItem.setSelectedGroup(art);
                                    WorldEditor.open(new WorldEditorUISearchItemProvider(groupWorldSearchItem, null, XNavigateComposite.TableLoadOption.NoUI));
                                    return Status.OK_STATUS;
                                }
                            }
                            Artifact[] artifactArray = artifacts;
                            int n = artifacts.length;
                            int n2 = 0;
                            while (n2 < n) {
                                art = artifactArray[n2];
                                if (AtsObjects.isAtsWorkItemOrAction((Object)art)) {
                                    arts.add(art);
                                } else if (art.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.UniversalGroup})) {
                                    for (Artifact relArt : art.getRelatedArtifacts(CoreRelationTypes.UniversalGrouping_Members)) {
                                        if (!AtsObjects.isAtsWorkItemOrAction((Object)relArt)) continue;
                                        arts.add(relArt);
                                    }
                                }
                                ++n2;
                            }
                        }
                        if (arts.size() > 0) {
                            WorldEditor.open(new WorldEditorSimpleProvider(name, arts));
                        }
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                        return new Status(4, "org.eclipse.osee.ats.ide", ex.getLocalizedMessage(), (Throwable)ex);
                    }
                    return Status.OK_STATUS;
                }
            };
            Jobs.startJob((Job)job);
        }
    }
}

