/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world;

import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.ats.ide.world.WorldEditorReloadProvider;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.util.FormsUtil;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ExceptionComposite;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class WorldReloadTab
extends FormPage {
    private IManagedForm managedForm;
    private Composite bodyComp;
    public static final String ID = "ats.world.reload.tab";
    private final WorldEditor editor;
    private final WorldEditorReloadProvider provider;
    private boolean reloading;
    private Button reloadButton;

    public WorldReloadTab(WorldEditor editor, WorldEditorReloadProvider provider) {
        super((FormEditor)editor, ID, "Reload");
        this.editor = editor;
        this.provider = provider;
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.managedForm = managedForm;
        try {
            this.updateTitleBar();
            this.bodyComp = managedForm.getForm().getBody();
            this.bodyComp.setLayout((Layout)new GridLayout(1, false));
            this.bodyComp.setLayoutData((Object)new GridData(16384, 16384, true, false));
            if (this.provider.getValidArtIds().isEmpty()) {
                managedForm.getToolkit().createLabel(this.bodyComp, "Nothing to reload.");
            } else {
                this.reloadButton = new Button(this.bodyComp, 8);
                this.reloadButton.setText("Reload");
                this.reloadButton.setImage(ImageManager.getImage((KeyedImage)FrameworkImage.REFRESH));
                final WorldReloadTab page = this;
                this.reloadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (WorldReloadTab.this.reloading) {
                            AWorkbench.popup((String)"Editor Reloading...");
                        } else {
                            WorldReloadTab.this.reloading = true;
                            WorldReloadTab.this.loadEditor(page);
                        }
                    }
                });
            }
            FormsUtil.addHeadingGradient((FormToolkit)this.editor.getToolkit(), (ScrolledForm)managedForm.getForm(), (boolean)true);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void handleException(Exception ex) {
        if (Widgets.isAccessible((Widget)this.bodyComp)) {
            this.bodyComp.dispose();
        }
        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        new ExceptionComposite(this.bodyComp, ex);
        this.bodyComp.layout();
    }

    private void updateTitleBar() {
        String displayableTitle = Strings.escapeAmpersands((String)this.provider.getName());
        if (this.managedForm != null && Widgets.isAccessible((Widget)this.managedForm.getForm())) {
            this.managedForm.getForm().setText(displayableTitle);
            this.managedForm.getForm().setImage(ImageManager.getImage((OseeImage)AtsImage.GLOBE));
        }
        this.setPartName(displayableTitle);
    }

    public void dispose() {
        if (this.editor.getToolkit() != null) {
            this.editor.getToolkit().dispose();
        }
    }

    public void showBusy(boolean busy) {
        super.showBusy(busy);
        IManagedForm managedForm = this.getManagedForm();
        if (managedForm != null && Widgets.isAccessible((Widget)this.getManagedForm().getForm())) {
            this.getManagedForm().getForm().getForm().setBusy(busy);
        }
    }

    private void loadEditor(FormPage page) {
        final LoadAndRefreshJob loadAndRefresh = new LoadAndRefreshJob(this.provider.getName());
        Jobs.startJob((Job)loadAndRefresh, (boolean)false, (IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Displays.ensureInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (loadAndRefresh.isSuccess()) {
                            (this).WorldReloadTab.this.provider.setReload(false);
                            (this).WorldReloadTab.this.editor.addPages();
                            (this).WorldReloadTab.this.editor.removePage(0);
                        }
                    }
                });
            }
        });
    }

    private class LoadAndRefreshJob
    extends Job {
        boolean success;

        public boolean isSuccess() {
            return this.success;
        }

        public LoadAndRefreshJob(String name) {
            super(name);
            this.success = true;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (WorldReloadTab.this.provider.getValidArtIds().isEmpty()) {
                AWorkbench.popup((String)"No valid ids to reload.");
                this.success = false;
            } else {
                Displays.ensureInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (Widgets.isAccessible((Widget)((LoadAndRefreshJob)LoadAndRefreshJob.this).WorldReloadTab.this.reloadButton)) {
                            ((LoadAndRefreshJob)LoadAndRefreshJob.this).WorldReloadTab.this.reloadButton.setText("Reloading...");
                            ((LoadAndRefreshJob)LoadAndRefreshJob.this).WorldReloadTab.this.reloadButton.getParent().layout(true);
                        }
                    }
                });
                this.success = WorldReloadTab.this.provider.searchAndLoad();
            }
            return Status.OK_STATUS;
        }
    }
}

