/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.task.related;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.ats.api.task.related.IAutoGenTaskData;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.task.TaskEditor;
import org.eclipse.osee.ats.ide.workflow.task.related.AbstractShowRelatedAction;
import org.eclipse.osee.ats.ide.workflow.task.related.TaskEditorRelatedTasksProvider;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;

public class ShowRelatedTasksAction
extends AbstractShowRelatedAction {
    private Collection<String> srchStrs = new ArrayList<String>();

    public ShowRelatedTasksAction(ISelectedAtsArtifacts selectedAtsArtifacts) {
        super("Show Related Tasks", selectedAtsArtifacts);
    }

    public void run() {
        this.srchStrs = new ArrayList<String>();
        final Collection<IAtsTask> tasks = this.getSelectedTasks();
        if (!this.isAutoGenRelatedArtTasks(tasks)) {
            return;
        }
        for (IAtsTask task : tasks) {
            String srchStr;
            IAutoGenTaskData data = AtsApiService.get().getTaskRelatedService().getAutoGenTaskData(task);
            String string = srchStr = data.hasRelatedArt() ? data.getRelatedArtName() : task.getName();
            if (!Strings.isValid((String)srchStr)) {
                AWorkbench.popup((String)"ERROR", (String)"Unable to extract requirement from task name");
                return;
            }
            this.srchStrs.add(srchStr);
        }
        Job job = new Job("Show All Related Tasks"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        TaskEditor.open(new TaskEditorRelatedTasksProvider(ShowRelatedTasksAction.this.srchStrs, Collections.castAll((Collection)tasks), false, false));
                    }
                    catch (OseeCoreException ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.schedule();
    }
}

