/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.review.defect;

import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.review.ReviewDefectItem;
import org.eclipse.osee.ats.core.review.ReviewDefectError;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.workflow.review.PeerToPeerReviewArtifact;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

public class ReviewDefectValidator {
    public static ReviewDefectError isValid(Artifact artifact) {
        try {
            PeerToPeerReviewArtifact peerToPeerReviewArtifact;
            ReviewDefectError result;
            if (artifact instanceof PeerToPeerReviewArtifact && !(result = ReviewDefectValidator.isValid((peerToPeerReviewArtifact = (PeerToPeerReviewArtifact)artifact).getDefectManager().getDefectItems())).isOK()) {
                return result;
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return ReviewDefectError.ExceptionValidatingRoles;
        }
        return ReviewDefectError.None;
    }

    public static ReviewDefectError isValid(Set<ReviewDefectItem> defectItems) {
        try {
            for (ReviewDefectItem item : defectItems) {
                if (item.isClosed() && item.getDisposition() != ReviewDefectItem.Disposition.None && (item.getSeverity() != ReviewDefectItem.Severity.None || item.getDisposition() == ReviewDefectItem.Disposition.Duplicate || item.getDisposition() == ReviewDefectItem.Disposition.Reject)) continue;
                return ReviewDefectError.AllItemsMustBeMarkedAndClosed;
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return ReviewDefectError.ExceptionValidatingRoles;
        }
        return ReviewDefectError.None;
    }
}

