/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.goal;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.actions.newaction.CreateNewActionAtLocactionBlam;
import org.eclipse.osee.ats.ide.editor.tab.members.IMemberProvider;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.CollectorArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.BlamEditor;
import org.eclipse.osee.framework.ui.swt.ImageManager;

public class NewActionToGoalAction
extends Action {
    private final CollectorArtifact collectorArt;
    private final ISelectedAtsArtifacts selectedAtsArtifacts;
    private final IMemberProvider memberProvider;

    public NewActionToGoalAction(IMemberProvider memberProvider, CollectorArtifact collectorArt, ISelectedAtsArtifacts selectedAtsArtifacts) {
        super("Create New Action At This Location");
        this.memberProvider = memberProvider;
        this.collectorArt = collectorArt;
        this.selectedAtsArtifacts = selectedAtsArtifacts;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.NEW_ACTION);
    }

    public void run() {
        List<Artifact> selected = this.selectedAtsArtifacts.getSelectedAtsArtifacts();
        Artifact dropTarget = selected.isEmpty() ? null : (Artifact)selected.iterator().next();
        LinkedList<IAtsActionableItem> ais = new LinkedList<IAtsActionableItem>();
        if (this.memberProvider.isBacklog() || this.memberProvider.isSprint()) {
            Artifact agileTeam = null;
            agileTeam = this.memberProvider.isBacklog() ? this.collectorArt.getRelatedArtifact(AtsRelationTypes.AgileTeamToBacklog_AgileTeam) : this.collectorArt.getRelatedArtifact(AtsRelationTypes.AgileTeamToSprint_AgileTeam);
            List atsTeams = agileTeam.getRelatedArtifacts(AtsRelationTypes.AgileTeamToAtsTeam_AtsTeam);
            for (Artifact atsTeam : atsTeams) {
                for (Artifact ai : atsTeam.getRelatedArtifacts(AtsRelationTypes.TeamActionableItem_ActionableItem)) {
                    ais.add((IAtsActionableItem)AtsApiService.get().getActionableItemService().getActionableItemById((ArtifactId)ai));
                }
            }
        }
        CreateNewActionAtLocactionBlam blam = new CreateNewActionAtLocactionBlam(this.memberProvider, ais, dropTarget);
        BlamEditor.edit((AbstractBlam)blam);
    }

    public String getText() {
        return this.selectedAtsArtifacts.getSelectedWorkflowArtifacts().isEmpty() ? "Create New Action at End" : "Create New Action At This Location";
    }

    public void refreshText() {
        this.setText(this.getText());
    }

    public static interface RemovedFromCollectorHandler {
        public void removedFromCollector(Collection<? extends Artifact> var1);
    }
}

