/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.chgtype;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.chgtype.ChangeLabelProvider;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredListDialog;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class ChangeTypeDialog
extends FilteredListDialog<ChangeTypes> {
    private final Collection<IAtsTeamWorkflow> teamWfs;
    private boolean clearAllowed = true;
    private Composite container;
    private ChangeTypes initialChgType = null;

    public ChangeTypeDialog(Collection<IAtsTeamWorkflow> teamWfs, List<ChangeTypes> changeTypes) {
        super("Select Change Type", "Select Change Type", (ILabelProvider)new ChangeLabelProvider());
        if (teamWfs != null) {
            this.teamWfs = teamWfs;
            this.setInput(this.getValues());
        } else {
            this.teamWfs = null;
            this.setInput(changeTypes);
        }
    }

    protected Control createDialogArea(Composite container) {
        this.container = container;
        Control control = super.createDialogArea(container);
        if (this.initialChgType != null) {
            super.setSelection(Arrays.asList(this.initialChgType).toArray());
        }
        if (this.clearAllowed) {
            Composite composite = new Composite((Composite)control, 0);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData());
            Button button = new Button(composite, 8);
            button.setText("Clear and Close");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ChangeTypeDialog.this.setSelection(null);
                    ChangeTypeDialog.this.close();
                }
            });
        }
        return control;
    }

    public boolean isClearAllowedSelected() {
        if (!this.clearAllowed) {
            return false;
        }
        return this.clearAllowed;
    }

    public String getSelectedOption() {
        if (this.clearAllowed || this.getSelected() == null) {
            return "";
        }
        return ((ChangeTypes)this.getSelected()).getName();
    }

    public boolean isclearAllowed() {
        return this.clearAllowed;
    }

    public void setclearAllowed(boolean clearAllowed) {
        this.clearAllowed = clearAllowed;
    }

    private Collection<ChangeTypes> getValues() {
        Pair pair = AtsApiService.get().getWorkItemService().hasSameChangeTypes(this.teamWfs);
        boolean sameChangeTypes = (Boolean)pair.getFirst();
        Collection changeTypes = (Collection)pair.getSecond();
        if (!sameChangeTypes) {
            AWorkbench.popup((String)"Can not change Change Type for teams with different Change Types");
            return Collections.emptyList();
        }
        return changeTypes;
    }

    public void setSelected(ChangeTypes changeType) {
        if (Widgets.isAccessible((Widget)this.container)) {
            super.setSelection(Arrays.asList(changeType).toArray());
        } else {
            this.initialChgType = changeType;
        }
    }
}

