/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workdef;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.workdef.model.WidgetDefinition;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.skynet.widgets.XOption;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.util.DefaultXWidgetOptionResolver;
import org.eclipse.osee.framework.ui.skynet.widgets.util.FrameworkXWidgetProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.util.IXWidgetOptionResolver;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetRendererItem;

public class ValidateWorkDefXWidgetOperation {
    private final AtsApi atsApi;

    public ValidateWorkDefXWidgetOperation(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public XResultData run() {
        XResultData rd = new XResultData();
        for (WorkDefinition workDef : this.atsApi.getWorkDefinitionService().getAllWorkDefinitions()) {
            for (WidgetDefinition widgetDef : this.atsApi.getWorkDefinitionService().getWidgets(workDef)) {
                XWidget widget;
                String xWidgetName = widgetDef.getXWidgetName();
                if (!Strings.isValid((String)xWidgetName) || (widget = this.getWidget(xWidgetName)) != null && !widget.getLabel().contains("Unhandled XWidget")) continue;
                rd.errorf("Widget not found for [%s] in WorkDef %s\n", new Object[]{xWidgetName, workDef.toStringWithId()});
            }
        }
        return rd;
    }

    public XWidget getWidget(String xWidgetName) {
        SwtXWidgetRenderer dynamicXWidgetLayout = new SwtXWidgetRenderer(null, (IXWidgetOptionResolver)new DefaultXWidgetOptionResolver());
        XWidgetRendererItem dummyItem = new XWidgetRendererItem(dynamicXWidgetLayout, new XOption[]{XOption.NONE});
        XWidget widget = FrameworkXWidgetProvider.getXWidget((XWidgetRendererItem)dummyItem, (String)xWidgetName, (String)"IsInTest", null);
        return widget;
    }
}

