/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.dialog;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsObjectLabelProvider;
import org.eclipse.osee.ats.ide.util.widgets.dialog.AITreeContentProvider;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.util.ArtifactNameSorter;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredCheckboxTreeDialog;

public class ActionableItemListDialog
extends FilteredCheckboxTreeDialog<IAtsActionableItem> {
    public ActionableItemListDialog(Active active, String message) {
        super("Select Actionable Item(s)", "Select Actionable Item(s)", (IContentProvider)new AITreeContentProvider(active), (IBaseLabelProvider)new AtsObjectLabelProvider(), (ViewerComparator)new ArtifactNameSorter());
        try {
            this.setInput(AtsApiService.get().getActionableItemService().getTopLevelActionableItems(active));
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public Set<IAtsActionableItem> getSelected() {
        HashSet<IAtsActionableItem> selectedactionItems = new HashSet<IAtsActionableItem>();
        Object[] objectArray = this.getResult();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            selectedactionItems.add((IAtsActionableItem)obj);
            ++n2;
        }
        return selectedactionItems;
    }

    public void setInput(Object input) {
        super.setInput(input);
        if (input instanceof Collection) {
            Collection coll = (Collection)input;
            if (coll.size() == 1) {
                this.getTreeViewer().getViewer().expandToLevel(coll.iterator().next(), 1);
            }
        } else if (input instanceof IAtsActionableItem) {
            this.getTreeViewer().getViewer().expandToLevel(input, 1);
        }
    }
}

