/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.branch.BranchEnablementData;
import org.eclipse.osee.ats.api.branch.BranchStatus;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.jdk.core.type.LazyObject;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;

public class XWorkingBranchEnablement {
    private final LazyObject<BranchEnablementData> dataProvider;

    public XWorkingBranchEnablement(TeamWorkFlowArtifact teamArt) {
        this.dataProvider = new BranchEnablementLazyObject(teamArt);
    }

    private BranchEnablementData getEnablementData() {
        return (BranchEnablementData)this.dataProvider.get();
    }

    public boolean isCreateBranchButtonEnabled() {
        boolean result = false;
        BranchEnablementData data = this.getEnablementDataLogException();
        if (data != null && !data.isDisableAll()) {
            result = !data.isWorkingBranchCommitInProgress() && !data.isWorkingBranchCreationInProgress() && !data.isWorkingBranchInWork() && !data.isCommittedBranchExists();
        }
        return result;
    }

    public boolean isShowArtifactExplorerButtonEnabled() {
        boolean result = false;
        BranchEnablementData data = this.getEnablementDataLogException();
        if (data != null && !data.isDisableAll()) {
            result = data.getWorkingBranch() != null && data.getBranchStatus().isChangesPermitted();
        }
        return result;
    }

    public boolean isShowChangeReportButtonEnabled() {
        boolean result = false;
        BranchEnablementData data = this.getEnablementDataLogException();
        if (data != null && !data.isDisableAll()) {
            result = data.isWorkingBranchInWork() || data.isCommittedBranchExists();
        }
        return result;
    }

    public boolean isDeleteBranchButtonEnabled() {
        boolean result = false;
        BranchEnablementData data = this.getEnablementDataLogException();
        if (data != null && !data.isDisableAll()) {
            result = data.isWorkingBranchInWork() && !data.isCommittedBranchExists();
        }
        return result;
    }

    public boolean isFavoriteBranchButtonEnabled() {
        boolean result = false;
        BranchEnablementData data = this.getEnablementDataLogException();
        if (data != null && !data.isDisableAll()) {
            result = data.isWorkingBranchInWork();
        }
        return result;
    }

    private BranchEnablementData getEnablementDataLogException() {
        BranchEnablementData data = null;
        try {
            data = this.getEnablementData();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        LazyObject<BranchEnablementData> lazyObject = this.dataProvider;
        synchronized (lazyObject) {
            this.dataProvider.invalidate();
        }
    }

    public BranchStatus getStatus() {
        return this.getEnablementData().getBranchStatus();
    }

    public BranchToken getWorkingBranch() {
        return this.getEnablementData().getWorkingBranch();
    }

    public void disableAll() {
        this.getEnablementData().setDisableAll(true);
    }

    public String toString() {
        String toReturn;
        try {
            BranchEnablementData data = this.getEnablementData();
            toReturn = data.toString();
        }
        catch (OseeCoreException ex) {
            toReturn = String.format("Error computing enablement data - [%s]", Lib.exceptionToString((Exception)((Object)ex)));
        }
        return toReturn;
    }

    public boolean isUpdateWorkingBranchButtonEnabled() {
        boolean result = false;
        BranchEnablementData data = this.getEnablementDataLogException();
        if (data != null && !data.isDisableAll()) {
            result = data.isWorkingBranchInWork() && !data.isCommittedBranchExists();
        }
        return result;
    }

    private static final class BranchEnablementLazyObject
    extends LazyObject<BranchEnablementData> {
        private final TeamWorkFlowArtifact teamArt;

        public BranchEnablementLazyObject(TeamWorkFlowArtifact teamArt) {
            this.teamArt = teamArt;
        }

        protected FutureTask<BranchEnablementData> createLoaderTask() {
            Callable<BranchEnablementData> callable = new Callable<BranchEnablementData>(){

                @Override
                public BranchEnablementData call() throws Exception {
                    BranchEnablementData enablementData = new BranchEnablementData((IAtsTeamWorkflow)teamArt, (AtsApi)AtsApiService.get());
                    if (teamArt != null) {
                        BranchToken workingBranch = AtsApiService.get().getBranchService().getWorkingBranch((IAtsTeamWorkflow)teamArt, true);
                        enablementData.setWorkingBranch(workingBranch);
                        enablementData.setWorkingBranchInWork(AtsApiService.get().getBranchService().isWorkingBranchInWork((IAtsTeamWorkflow)teamArt));
                        enablementData.setCommittedBranchExists(AtsApiService.get().getBranchService().isCommittedBranchExists((IAtsTeamWorkflow)teamArt));
                        enablementData.setDisableAll(enablementData.isWorkingBranchCommitInProgress());
                    }
                    return enablementData;
                }
            };
            return new FutureTask<BranchEnablementData>(callable);
        }
    }
}

