/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.List;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsApiIde;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlinkWfdForConfiguration;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.ui.skynet.internal.ServiceUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.AttributeWidget;
import org.eclipse.osee.framework.ui.swt.Widgets;

public class XHyperlinkWfdForConfigurationDam
extends XHyperlinkWfdForConfiguration
implements AttributeWidget {
    private Artifact artifact;
    private AttributeTypeToken attributeTypeToken;

    public void handleSelectionPersist(ArtifactToken selected) {
        SkynetTransaction tx = TransactionManager.createTransaction((BranchId)CoreBranches.COMMON, (String)"Set Config");
        this.artifact.setSoleAttributeValue((AttributeTypeId)this.attributeTypeToken, (Object)selected);
        tx.execute();
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void saveToArtifact() {
    }

    public void revert() {
    }

    public Result isDirty() {
        return Result.FalseResult;
    }

    public void setAttributeType(Artifact artifact, AttributeTypeToken attributeTypeToken) {
        this.artifact = artifact;
        this.attributeTypeToken = attributeTypeToken;
        if (artifact instanceof IAtsTeamWorkflow) {
            Version ver;
            IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)artifact;
            ArtifactToken versionId = AtsApiService.get().getRelationResolver().getRelatedOrSentinel((IAtsObject)teamWf, AtsRelationTypes.TeamWorkflowToFoundInVersion_Version);
            if (versionId.isValid() && (ver = AtsApiService.get().getVersionService().getVersionById((ArtifactId)versionId)) != null) {
                this.branch = ver.getBaselineBranch();
            }
        }
    }

    public AttributeTypeToken getAttributeType() {
        return this.attributeTypeToken;
    }

    public String getCurrentValue() {
        if (this.artifact == null) {
            return Widgets.NOT_SET;
        }
        Artifact build = this.artifact.getRelatedArtifactOrNull(AtsRelationTypes.TeamWorkflowToFoundInVersion_Version);
        if (build == null || build.isInvalid()) {
            return "Select Build";
        }
        ArtifactId config = (ArtifactId)this.artifact.getSoleAttributeValue((AttributeTypeId)this.attributeTypeToken, (Object)ArtifactId.SENTINEL);
        if (config.isInvalid()) {
            return Widgets.NOT_SET;
        }
        AtsApiIde atsApi = AtsApiService.get();
        Version version = atsApi.getVersionService().getVersionById((ArtifactId)build);
        BranchId branch = atsApi.getVersionService().getBaselineBranchIdInherited((IAtsVersion)version);
        if (branch == null || branch.isInvalid()) {
            return "Invalid Build Id: " + build.getIdString();
        }
        List views = ServiceUtil.getOseeClient().getApplicabilityEndpoint(branch).getViews();
        for (ArtifactToken view : views) {
            if (!view.equals(config)) continue;
            this.selected = view;
            return view.getName();
        }
        return "Invalid Config Id: " + config.getIdString();
    }
}

