/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.Priorities;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlinkPrioritySelection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.widgets.AttributeWidget;
import org.eclipse.osee.framework.ui.swt.Widgets;

public class XHyperlinkPrioritySelectionDam
extends XHyperlinkPrioritySelection
implements AttributeWidget {
    public static final String WIDGET_ID = XHyperlinkPrioritySelectionDam.class.getSimpleName();
    protected Artifact artifact;
    public static String NOT_SET = Widgets.NOT_SET;

    public XHyperlinkPrioritySelectionDam() {
        this("");
    }

    public XHyperlinkPrioritySelectionDam(String label) {
        super(label);
    }

    public XHyperlinkPrioritySelectionDam(String label, Priorities ... priorities) {
        super(label, priorities);
    }

    @Override
    protected void handleSelected(Priorities selected) {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("Set Priority");
        if (selected == null || selected == Priorities.None) {
            changes.deleteAttributes((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.Priority);
        } else {
            changes.setSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.Priority, (Object)selected.name());
        }
        changes.executeIfNeeded();
        super.handleSelected(selected);
    }

    @Override
    protected List<Priorities> getPriorities() {
        if (this.priorities != null && !this.priorities.isEmpty()) {
            return this.priorities;
        }
        List options = AtsApiService.get().getWorkItemService().getPrioritiesOptions((IAtsObject)((IAtsTeamWorkflow)this.artifact));
        return options;
    }

    @Override
    public String getCurrentValue() {
        String value = this.artifact.getAttributesToString((AttributeTypeId)AtsAttributeTypes.Priority);
        if (Strings.isInValid((String)value)) {
            value = NOT_SET;
        }
        return value;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void saveToArtifact() {
    }

    public void revert() {
    }

    public Result isDirty() {
        return Result.FalseResult;
    }

    public void setAttributeType(Artifact artifact, AttributeTypeToken attributeType) {
        this.artifact = artifact;
    }

    public AttributeTypeToken getAttributeType() {
        return AtsAttributeTypes.Priority;
    }

    @Override
    public IStatus isValid() {
        IStatus status = Status.OK_STATUS;
        try {
            if (this.getArtifact() != null && this.getAttributeType() != null) {
                String currValue = this.getCurrentValue();
                if (NOT_SET.equals(currValue)) {
                    currValue = "";
                }
                if (this.isRequiredEntry() && Strings.isInValid((String)currValue)) {
                    status = new Status(4, "org.eclipse.osee.framework.ui.skynet", String.format("Must select [%s]", this.getAttributeType().getUnqualifiedName()));
                }
            }
        }
        catch (OseeCoreException ex) {
            status = new Status(4, "org.eclipse.osee.framework.ui.skynet", "Error getting Artifact", (Throwable)ex);
        }
        return status;
    }
}

