/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.applicability.FeatureDefinition;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.utility.Branches;
import org.eclipse.osee.framework.ui.plugin.util.ArrayTreeContentProvider;
import org.eclipse.osee.framework.ui.plugin.util.StringLabelProvider;
import org.eclipse.osee.framework.ui.skynet.util.StringNameComparator;
import org.eclipse.osee.framework.ui.skynet.widgets.AttributeWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkLabelValueSelection;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredCheckboxTreeDialog;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.osee.orcs.rest.model.ApplicabilityEndpoint;
import org.eclipse.ui.progress.UIJob;

public class XHyperlinkFeatureDam
extends XHyperlinkLabelValueSelection
implements AttributeWidget {
    private IAtsTeamWorkflow teamWf;
    private AttributeTypeToken attributeTypeToken;
    private final AtsApi atsApi;
    private String value = Widgets.NOT_SET;
    private Collection<Object> values;

    public XHyperlinkFeatureDam() {
        this("Feature");
    }

    public XHyperlinkFeatureDam(String label) {
        super(label);
        this.atsApi = AtsApiService.get();
    }

    public String getCurrentValue() {
        return this.value;
    }

    public Artifact getArtifact() {
        return (Artifact)this.teamWf.getStoreObject();
    }

    public void saveToArtifact() {
    }

    public void revert() {
    }

    public Result isDirty() {
        return Result.FalseResult;
    }

    public void setAttributeType(Artifact artifact, AttributeTypeToken attributeTypeToken) {
        this.attributeTypeToken = attributeTypeToken;
        if (artifact instanceof IAtsTeamWorkflow) {
            this.teamWf = (IAtsTeamWorkflow)artifact;
        }
    }

    public boolean handleSelection() {
        try {
            FilteredCheckboxTreeDialog dialog = new FilteredCheckboxTreeDialog("Select Feature(s) Impacted", "Select Feature(s) Impacted", (IContentProvider)new ArrayTreeContentProvider(), (IBaseLabelProvider)new StringLabelProvider(), (ViewerComparator)new StringNameComparator());
            dialog.setInput(this.getFeatureDefinitions());
            Collection<FeatureDefinition> selectedFeatures = this.getSelectedFeatures();
            if (!selectedFeatures.isEmpty()) {
                dialog.setInitialSelections(selectedFeatures);
            }
            dialog.setShowSelectButtons(true);
            if (dialog.open() == 0) {
                ArrayList<ArtifactId> values = new ArrayList<ArtifactId>();
                Collection checked = dialog.getChecked();
                for (FeatureDefinition featureDef : checked) {
                    values.add(ArtifactId.valueOf((Long)featureDef.getId()));
                }
                IAtsChangeSet changes = this.atsApi.createChangeSet(this.getLabel());
                changes.setAttributeValues((IAtsObject)this.teamWf, this.attributeTypeToken, values);
                changes.execute();
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return false;
    }

    private Collection<FeatureDefinition> getSelectedFeatures() {
        ArrayList<FeatureDefinition> selected = new ArrayList<FeatureDefinition>();
        this.values = this.atsApi.getAttributeResolver().getAttributeValues((IAtsObject)this.teamWf, this.attributeTypeToken);
        if (!this.values.isEmpty()) {
            for (Object obj : this.values) {
                ArtifactId featureId = (ArtifactId)obj;
                for (FeatureDefinition fDef : this.getFeatureDefinitions()) {
                    if (!fDef.getId().equals(featureId.getId())) continue;
                    selected.add(fDef);
                }
            }
        }
        return selected;
    }

    public void refresh() {
        this.values = this.atsApi.getAttributeResolver().getAttributeValues((IAtsObject)this.teamWf, this.attributeTypeToken);
        if (this.values.isEmpty()) {
            this.value = Widgets.NOT_SET;
            super.refresh();
        } else {
            ArrayList<1> ops = new ArrayList<1>();
            final XHyperlinkFeatureDam fHyperlinkFeatureDam = this;
            AbstractOperation op = new AbstractOperation("Load Features", "org.eclipse.osee.ats.ide"){

                protected void doWork(IProgressMonitor monitor) throws Exception {
                    ArrayList<String> valueStrs = new ArrayList<String>();
                    for (Object obj : XHyperlinkFeatureDam.this.values) {
                        ArtifactId featureId = (ArtifactId)obj;
                        for (FeatureDefinition fDef : fHyperlinkFeatureDam.getFeatureDefinitions()) {
                            if (!featureId.getId().equals(fDef.getId())) continue;
                            valueStrs.add(fDef.getName());
                        }
                    }
                    Collections.sort(valueStrs);
                    XHyperlinkFeatureDam.this.value = org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)";  ", valueStrs);
                }
            };
            ops.add(op);
            IOperation operation = Operations.createBuilder((String)"Load Feature Widget").addAll(ops).build();
            Operations.executeAsJob((IOperation)operation, (boolean)false, (int)30, (IJobChangeListener)new ReloadJobChangeAdapter(this));
        }
    }

    public void refreshSuper() {
        super.refresh();
    }

    public AttributeTypeToken getAttributeType() {
        return this.attributeTypeToken;
    }

    private List<FeatureDefinition> getFeatureDefinitions() {
        BranchToken branch = this.getBranch();
        if (Branches.isValid((BranchId)branch)) {
            ApplicabilityEndpoint applicEndpoint = AtsApiService.get().getOseeClient().getApplicabilityEndpoint((BranchId)branch);
            return applicEndpoint.getFeatureDefinitionData();
        }
        return Collections.emptyList();
    }

    private BranchToken getBranch() {
        if (this.teamWf != null) {
            BranchToken branch = this.atsApi.getBranchService().getWorkingBranch(this.teamWf);
            if (Branches.isValid((BranchId)branch)) {
                return branch;
            }
            Collection branches = this.atsApi.getBranchService().getBranchesCommittedTo(this.teamWf);
            if (Branches.isNotEmpty((Collection)branches)) {
                return (BranchToken)branches.iterator().next();
            }
            IAtsTeamDefinition teamDef = this.teamWf.getTeamDefinition();
            BranchId branch2 = this.atsApi.getBranchService().getBranch((IAtsConfigObject)teamDef);
            if (Branches.isValid((BranchId)branch2)) {
                return this.atsApi.getBranchService().getBranch(branch2);
            }
            IAtsTeamDefinition mainTeamDef = this.atsApi.getTeamDefinitionService().getTeamDefHoldingVersions(teamDef);
            if (mainTeamDef != null) {
                BranchId branch3 = this.atsApi.getBranchService().getBranch((IAtsConfigObject)mainTeamDef);
                if (Branches.isValid((BranchId)branch3)) {
                    return this.atsApi.getBranchService().getBranch(branch3);
                }
                for (IAtsVersion ver : this.atsApi.getVersionService().getVersions(mainTeamDef)) {
                    BranchId branch4 = this.atsApi.getBranchService().getBranch((IAtsConfigObject)ver);
                    if (!Branches.isValid((BranchId)branch4)) continue;
                    return this.atsApi.getBranchService().getBranch(branch4);
                }
            }
        }
        return BranchToken.SENTINEL;
    }

    private final class ReloadJobChangeAdapter
    extends JobChangeAdapter {
        private final XHyperlinkFeatureDam xHyperlinkFeatureDam;

        private ReloadJobChangeAdapter(XHyperlinkFeatureDam xHyperlinkFeatureDam2) {
            this.xHyperlinkFeatureDam = xHyperlinkFeatureDam2;
        }

        public void done(IJobChangeEvent event) {
            super.done(event);
            UIJob job = new UIJob("Load Selected Feature(s)"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ReloadJobChangeAdapter.this.xHyperlinkFeatureDam.refreshSuper();
                    return Status.OK_STATUS;
                }
            };
            Operations.scheduleJob((Job)job, (boolean)false, (int)20, null);
        }
    }
}

