/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.util.widgets.dialog.TeamDefinitionTreeWithChildrenDialog;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkLabelCmdValueSelection;

public class XHyperlabelTeamDefinitionSelection
extends XHyperlinkLabelCmdValueSelection {
    Collection<TeamDefinition> selectedTeamDefs = new HashSet<TeamDefinition>();
    Collection<TeamDefinition> teamDefs;
    TeamDefinitionTreeWithChildrenDialog dialog = null;

    public XHyperlabelTeamDefinitionSelection() {
        this("Team Definition(s)");
    }

    public XHyperlabelTeamDefinitionSelection(String label) {
        super(label, true, Integer.valueOf(80));
    }

    public Collection<TeamDefinition> getSelectedTeamDefintions() {
        return this.selectedTeamDefs;
    }

    public Object getData() {
        List arts = Collections.castAll(this.getSelectedTeamDefintions());
        return arts;
    }

    public String getCurrentValue() {
        return Collections.toString((String)",", this.selectedTeamDefs);
    }

    public void setSelectedTeamDefs(Collection<TeamDefinition> selectedTeamDefs) {
        this.selectedTeamDefs = selectedTeamDefs;
        this.refresh();
        this.notifyXModifiedListeners();
    }

    public boolean handleClear() {
        this.selectedTeamDefs.clear();
        this.notifyXModifiedListeners();
        return true;
    }

    public boolean handleSelection() {
        try {
            this.dialog = this.teamDefs == null ? new TeamDefinitionTreeWithChildrenDialog(Active.Both) : new TeamDefinitionTreeWithChildrenDialog(Active.Both, this.teamDefs);
            int result = this.dialog.open();
            if (result == 0) {
                this.selectedTeamDefs.clear();
                for (TeamDefinition obj : this.dialog.getResultAndRecursedTeamDefs()) {
                    this.selectedTeamDefs.add(obj);
                }
                this.notifyXModifiedListeners();
            }
            return true;
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return false;
        }
    }

    public void setTeamDefs(Collection<TeamDefinition> teamDefs) {
        this.teamDefs = teamDefs;
        if (this.dialog != null) {
            this.dialog.setInput(teamDefs);
        }
    }

    public boolean isEmpty() {
        return this.selectedTeamDefs.isEmpty();
    }
}

