/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.ats.ide.util.IArtifactMembersCache;
import org.eclipse.osee.ats.ide.workflow.CollectorArtifact;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.type.DoubleKeyHashMap;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.filter.ArtifactEventFilter;
import org.eclipse.osee.framework.skynet.core.event.filter.IEventFilter;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IEventListener;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;

public class ArtifactCollectorsCache<T extends CollectorArtifact>
implements IArtifactMembersCache<T> {
    private static Map<Long, List<Artifact>> cache;
    private static DoubleKeyHashMap<Long, Long, String> collectorMemberOrderMap;
    private static Set<Long> registered;
    private static volatile boolean initialized;
    private final RelationTypeSide memberRelationType;

    static {
        initialized = false;
    }

    public ArtifactCollectorsCache(RelationTypeSide memberRelationType) {
        this.memberRelationType = memberRelationType;
    }

    private void initializeStructures() {
        if (!initialized) {
            initialized = true;
            cache = new HashMap<Long, List<Artifact>>();
            registered = new HashSet<Long>();
            collectorMemberOrderMap = new DoubleKeyHashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerForEvents(T collectorArt) {
        if (!registered.contains(collectorArt.getId())) {
            IArtifactEventListener eventListener = new IArtifactEventListener((CollectorArtifact)collectorArt){
                private final /* synthetic */ CollectorArtifact val$collectorArt;
                {
                    this.val$collectorArt = collectorArtifact;
                }

                public List<? extends IEventFilter> getEventFilters() {
                    return Arrays.asList(new ArtifactEventFilter((ArtifactToken)this.val$collectorArt));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleArtifactEvent(ArtifactEvent artifactEvent, Sender sender) {
                    Object object = cache;
                    synchronized (object) {
                        cache.remove(this.val$collectorArt.getId());
                    }
                    object = collectorMemberOrderMap;
                    synchronized (object) {
                        Map subHash = collectorMemberOrderMap.getSubHash((Object)this.val$collectorArt.getId());
                        if (subHash != null) {
                            ArrayList keys = new ArrayList(subHash.keySet());
                            for (Long key1 : keys) {
                                collectorMemberOrderMap.remove((Object)this.val$collectorArt.getId(), (Object)key1);
                            }
                        }
                    }
                    object = registered;
                    synchronized (object) {
                        registered.remove(this.val$collectorArt.getId());
                    }
                }
            };
            OseeEventManager.addListener((IEventListener)eventListener);
            Set<Long> set = registered;
            synchronized (set) {
                registered.add(collectorArt.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Artifact> getMembers(T collector) {
        this.initializeStructures();
        this.registerForEvents(collector);
        List members = cache.get(collector.getId());
        if (members == null) {
            members = collector.getRelatedArtifacts(this.memberRelationType, DeletionFlag.EXCLUDE_DELETED);
            Map<Long, List<Artifact>> map = cache;
            synchronized (map) {
                cache.put(collector.getId(), members);
                this.fillOrderCache(collector, members);
            }
        }
        LinkedList<Artifact> linkedList = new LinkedList<Artifact>(members);
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decache(T collectorArt) {
        if (initialized) {
            Map<Long, List<Artifact>> map = cache;
            synchronized (map) {
                cache.remove(collectorArt.getId());
            }
            map = collectorMemberOrderMap;
            synchronized (map) {
                this.clearOrderCache(collectorArt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        if (initialized) {
            Map<Long, List<Artifact>> map = cache;
            synchronized (map) {
                cache.clear();
            }
            map = collectorMemberOrderMap;
            synchronized (map) {
                collectorMemberOrderMap.clear();
            }
        }
    }

    @Override
    public String getMemberOrder(T collectorArt, Artifact member) {
        String order;
        this.initializeStructures();
        if (collectorMemberOrderMap.getSubHash((Object)collectorArt.getId()) == null) {
            this.fillOrderCache(collectorArt, this.getMembers(collectorArt));
        }
        return (order = (String)collectorMemberOrderMap.get((Object)collectorArt.getId(), (Object)member.getId())) == null ? "" : order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillOrderCache(T collectorArt, List<Artifact> members) {
        this.initializeStructures();
        DoubleKeyHashMap<Long, Long, String> doubleKeyHashMap = collectorMemberOrderMap;
        synchronized (doubleKeyHashMap) {
            this.clearOrderCache(collectorArt);
            int x = 1;
            for (Artifact artifact : members) {
                collectorMemberOrderMap.put((Object)collectorArt.getId(), (Object)artifact.getId(), (Object)String.valueOf(x++));
            }
        }
    }

    private void clearOrderCache(T collectorArt) {
        if (initialized) {
            ArrayList memberIds = new ArrayList();
            Map subHash = collectorMemberOrderMap.getSubHash((Object)collectorArt.getId());
            if (subHash != null) {
                memberIds.addAll(subHash.keySet());
                for (Long memberId : memberIds) {
                    collectorMemberOrderMap.remove((Object)collectorArt.getId(), (Object)memberId);
                }
            }
        }
    }
}

