/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.util.SubscribeManager;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SubscribeManagerUI {
    private final Collection<AbstractWorkflowArtifact> awas;

    public SubscribeManagerUI(AbstractWorkflowArtifact sma) {
        this(Arrays.asList(sma));
    }

    public SubscribeManagerUI(Collection<AbstractWorkflowArtifact> awas) {
        this.awas = awas;
    }

    public void toggleSubscribe(boolean prompt) {
        try {
            if (SubscribeManager.amISubscribed(this.awas.iterator().next())) {
                boolean result = true;
                if (prompt) {
                    result = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Un-Subscribe", (String)"You are currently subscribed to receive emails when this artifact transitions.\n\nAre You sure you wish to Un-Subscribe?");
                }
                if (result) {
                    SubscribeManager.toggleSubscribe(this.awas);
                }
            } else {
                boolean result = true;
                if (prompt) {
                    result = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Subscribe", (String)"Are you sure you wish to subscribe to receive emails when this artifact transitions?");
                }
                if (result) {
                    SubscribeManager.toggleSubscribe(this.awas);
                }
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }
}

