/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search.quick;

import java.io.File;
import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.search.quick.AtsQuickSearchData;
import org.eclipse.osee.ats.ide.search.quick.AtsQuickSearchOperation;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.ats.ide.world.WorldEditorSimpleProvider;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.util.OseeInf;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.widgets.XCheckBox;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;

public class AtsQuickSearchComposite
extends Composite {
    Text searchArea;
    XCheckBox completeCancelledCheck;

    public AtsQuickSearchComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)ALayout.getZeroMarginLayout((int)4, (boolean)false));
        this.setLayoutData(new GridData(768));
        Button searchButton = new Button((Composite)this, 8);
        searchButton.setText("Search:");
        searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AtsQuickSearchComposite.this.handleSearch();
            }
        });
        searchButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent mouseEvent) {
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                if (mouseEvent.button == 3) {
                    try {
                        File file = OseeInf.getResourceAsFile((String)"misc/OSEEDay.wav", this.getClass());
                        Program.launch((String)file.getAbsolutePath());
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    }
                }
            }

            public void mouseDown(MouseEvent arg0) {
            }
        });
        GridData gridData = new GridData(131072, 0, false, false);
        gridData.heightHint = 15;
        this.searchArea = new Text((Composite)this, 2052);
        GridData gd = new GridData(4, 0, true, false);
        this.searchArea.setFont(parent.getFont());
        this.searchArea.setLayoutData((Object)gd);
        this.searchArea.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\r') {
                    AtsQuickSearchComposite.this.handleSearch();
                }
            }
        });
        this.searchArea.setToolTipText("ATS Quick Search - Type in a search string and press enter.\nOr right-click Paste and Go.");
        this.addContextMenu(this.searchArea);
        this.completeCancelledCheck = new XCheckBox("IC");
        this.completeCancelledCheck.createWidgets((Composite)this, 2);
        this.completeCancelledCheck.setToolTip("Include completed/cancelled ATS Artifacts");
    }

    private void addContextMenu(final Text control) {
        Menu menu = new Menu((Control)control);
        MenuItem item = new MenuItem(menu, 8);
        item.setText("Cut");
        item.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                control.cut();
            }
        });
        item = new MenuItem(menu, 8);
        item.setText("Copy");
        item.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                control.copy();
            }
        });
        item = new MenuItem(menu, 8);
        item.setText("Paste");
        item.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                control.paste();
            }
        });
        item = new MenuItem(menu, 8);
        item.setText("Paste-and-Go");
        item.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                control.setText("");
                control.paste();
                AtsQuickSearchComposite.this.handleSearch();
            }
        });
        item = new MenuItem(menu, 8);
        item.setText("Select All");
        item.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                control.selectAll();
            }
        });
        control.setMenu(menu);
    }

    private void handleSearch() {
        if (!Strings.isValid((String)this.searchArea.getText())) {
            AWorkbench.popup((String)"Please enter search string");
            return;
        }
        String srchText = this.searchArea.getText().trim();
        final AtsQuickSearchData data = new AtsQuickSearchData("ATS Quick Search", srchText, this.completeCancelledCheck.isChecked());
        Job srchJob = new Job("ATS - Search by ID(s)"){

            protected IStatus run(IProgressMonitor monitor) {
                AtsQuickSearchOperation operation = new AtsQuickSearchOperation(data);
                final Collection<Artifact> artifacts = operation.performSearch();
                Displays.ensureInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (artifacts.isEmpty()) {
                            AWorkbench.popup((String)data.toString(), (String)(String.valueOf(data.toString()) + "\n\nNo Results Found"));
                        } else if (artifacts.size() == 1 && ((Artifact)artifacts.iterator().next()).isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact})) {
                            WorkflowEditor.editArtifact((Artifact)artifacts.iterator().next());
                        } else {
                            WorldEditor.open(new WorldEditorSimpleProvider(data.toString(), artifacts));
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        Jobs.startJob((Job)srchJob);
    }
}

