/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search;

import java.util.Collection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredListDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class AttributeTypeFilteredDialog
extends FilteredListDialog<AttributeTypeToken> {
    private boolean nonExists = false;
    private AttributeTypeToken selectedElement = AttributeTypeToken.SENTINEL;
    private final AtsApi atsApi;

    public AttributeTypeFilteredDialog(Collection<AttributeTypeToken> attributeTypes) {
        super("Select Attribute Type", "Select Attribute Type", (ILabelProvider)new AttributeTypeLabelProvider());
        this.setInput(attributeTypes);
        this.atsApi = AtsApiService.get();
    }

    protected Control createDialogArea(Composite container) {
        Control control = super.createDialogArea(container);
        Composite composite = new Composite((Composite)control, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData());
        Button notExistsButton = new Button(composite, 8);
        notExistsButton.setText("\"Not Exists\" and Close");
        notExistsButton.setToolTipText("Select to add Not Exists Attribute Type to query");
        notExistsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selectedElements = AttributeTypeFilteredDialog.this.getSelectedElements();
                if (selectedElements.length == 0) {
                    AWorkbench.popup((String)"Must Select at Attribute Type");
                    return;
                }
                AttributeTypeFilteredDialog.this.selectedElement = (AttributeTypeToken)selectedElements[0];
                AttributeTypeFilteredDialog.this.nonExists = true;
                AttributeTypeFilteredDialog.this.close();
            }
        });
        return control;
    }

    public boolean isNonExists() {
        return this.nonExists;
    }

    public AttributeTypeToken getSelectedElement() {
        return this.selectedElement;
    }

    public static class AttributeTypeLabelProvider
    implements ILabelProvider {
        public String getText(Object arg0) {
            AttributeTypeToken type = (AttributeTypeToken)arg0;
            if (Strings.isValid((String)type.getDescription())) {
                return String.format("%s - %s", type.getName(), type.getDescription());
            }
            return type.getName();
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }

        public Image getImage(Object element) {
            return null;
        }
    }
}

