/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.operation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.enums.Active;

public class WorkflowsActiveAisContentProvider
implements ITreeContentProvider {
    private final Active active;
    private TeamWorkFlowArtifact teamWf;

    public WorkflowsActiveAisContentProvider(TeamWorkFlowArtifact teamWf, Active active) {
        this.teamWf = teamWf;
        this.active = active;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList ais = new ArrayList();
        if (inputElement instanceof TeamWorkFlowArtifact) {
            TeamWorkFlowArtifact teamWf = (TeamWorkFlowArtifact)((Object)inputElement);
            ais.addAll(AtsApiService.get().getActionableItemService().getActionableItems(teamWf.getTeamDefinition()));
        }
        return ais.toArray(new Object[ais.size()]);
    }

    public Object[] getChildren(Object inputElement) {
        ArrayList<IAtsActionableItem> ais = new ArrayList<IAtsActionableItem>();
        if (inputElement instanceof IAtsActionableItem) {
            IAtsActionableItem ai = (IAtsActionableItem)inputElement;
            for (IAtsActionableItem childAi : ai.getChildrenActionableItems()) {
                ais.addAll(WorkflowsActiveAisContentProvider.getActiveChildrenForTeamAndAi(this.teamWf.getTeamDefinition(), this.active, childAi));
            }
        }
        return ais.toArray(new Object[ais.size()]);
    }

    public Object getParent(Object element) {
        Object parent = null;
        if (element instanceof IAtsActionableItem) {
            if (this.teamWf != null && this.teamWf.getActionableItems().contains(element)) {
                parent = this.teamWf;
            } else {
                IAtsActionableItem ai = (IAtsActionableItem)element;
                parent = ai.getParentActionableItem();
            }
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    private static List<IAtsActionableItem> getActiveChildrenForTeamAndAi(IAtsTeamDefinition teamDef, Active active, IAtsActionableItem ai) {
        ArrayList<IAtsActionableItem> results = new ArrayList<IAtsActionableItem>();
        if (ai.getTeamDefinition() == null || ai.getTeamDefinition().equals(teamDef)) {
            if (active == Active.Both) {
                results.add(ai);
            } else {
                boolean attributeActive = ai.isActive();
                if (active == Active.Active && attributeActive) {
                    results.add(ai);
                } else if (active == Active.InActive && !attributeActive) {
                    results.add(ai);
                }
            }
        }
        return results;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public TeamWorkFlowArtifact getTeamWf() {
        return this.teamWf;
    }

    public void setTeamWf(TeamWorkFlowArtifact teamWf) {
        this.teamWf = teamWf;
    }
}

