/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.navigate;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.navigate.AtsNavigateViewItems;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.revision.ChangeManager;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialogWithBranchSelect;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredCheckboxTreeArtifactDialog;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class ArtifactImpactToActionSearchItem
extends XNavigateItemAction {
    private static final String TITLE = "Search Artifact Impact to Action";

    public ArtifactImpactToActionSearchItem() {
        super(TITLE, (KeyedImage)FrameworkImage.FLASHLIGHT, new XNavItemCat[]{AtsNavigateViewItems.ATS_ADVANCED_SEARCHES});
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        EntryDialogWithBranchSelect ed = new EntryDialogWithBranchSelect(this.getName(), "Enter Artifact Name (or string) to search (no wildcards)");
        if (ed.open() == 0) {
            ActionToArtifactImpactJob job = new ActionToArtifactImpactJob(ed.getEntry(), ed.getBranch());
            job.setUser(true);
            job.setPriority(30);
            job.schedule();
        }
    }

    public static class ActionToArtifactImpactJob
    extends Job {
        private IProgressMonitor monitor;
        private final String artifactName;
        private final XResultData rd = new XResultData();
        private final BranchId branch;

        public ActionToArtifactImpactJob(String artifactName, BranchId branch) {
            super("Searching \"" + artifactName + "\"...");
            this.artifactName = artifactName;
            this.branch = branch;
        }

        public IStatus run(IProgressMonitor monitor) {
            this.monitor = monitor;
            try {
                this.getMatrixItems();
                XResultDataUI.report((XResultData)this.rd, (String)("Search Artifact Impact to Action - \"" + this.artifactName + "\""));
                return Status.OK_STATUS;
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                return new Status(4, "org.eclipse.osee.ats.ide", -1, ex.getMessage(), (Throwable)ex);
            }
        }

        private void getMatrixItems() {
            final List srchArts = ArtifactQuery.getArtifactListFromName((String)this.artifactName, (BranchId)this.branch, (DeletionFlag)DeletionFlag.INCLUDE_DELETED, (QueryOption[])QueryOption.CONTAINS_MATCH_OPTIONS);
            final HashSet processArts = new HashSet();
            if (srchArts.isEmpty()) {
                return;
            }
            if (srchArts.size() > 1) {
                Displays.pendInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FilteredCheckboxTreeArtifactDialog dialog = new FilteredCheckboxTreeArtifactDialog(ArtifactImpactToActionSearchItem.TITLE, "Select Artifacts to Search", srchArts);
                        if (dialog.open() == 0) {
                            processArts.addAll(dialog.getChecked());
                        }
                    }
                });
            } else {
                processArts.addAll(srchArts);
            }
            int x = 1;
            this.rd.log("Artifact Impact to Action for artifact(s) on branch \"" + this.branch.getIdString() + "\"");
            HashCollection transactionMap = ChangeManager.getModifingTransactions(processArts);
            HashCollection branchMap = ChangeManager.getModifingBranches(processArts);
            for (Artifact srchArt : processArts) {
                String str = String.format("Processing %d/%d - %s ", x++, processArts.size(), srchArt.getName());
                this.rd.log("\n" + AHTML.bold((String)srchArt.getName()));
                this.monitor.subTask(str);
                int y = 1;
                this.rd.addRaw(AHTML.beginMultiColumnTable((int)95, (int)1));
                this.rd.addRaw(AHTML.addHeaderRowMultiColumnTable((String[])new String[]{"Type", "Status", "ID", "Title"}));
                boolean workingBranchesFound = false;
                Collection branches = branchMap.getValues((Object)srchArt);
                if (branches != null) {
                    for (BranchId branch : branches) {
                        Artifact assocArt = BranchManager.getAssociatedArtifact((BranchId)branch);
                        if (assocArt.isValid()) {
                            this.rd.addRaw(AHTML.addRowMultiColumnTable((String[])new String[]{assocArt.getArtifactTypeName(), "Working", XResultDataUI.getHyperlink((Artifact)assocArt), assocArt.getName()}));
                        } else {
                            this.rd.addRaw(AHTML.addRowMultiColumnTable((String[])new String[]{"Branch", "", BranchManager.getBranchToken((BranchId)branch).getName()}));
                        }
                        workingBranchesFound = true;
                    }
                }
                if (!workingBranchesFound) {
                    this.rd.addRaw(AHTML.addRowSpanMultiColumnTable((String)"No Impacting Working Branches Found", (int)3));
                }
                boolean committedChanges = false;
                Collection transactions = transactionMap.getValues((Object)srchArt);
                if (transactions != null) {
                    for (TransactionId transactionId : transactions) {
                        String transStr = String.format("Tranaction %d/%d", y++, transactions.size());
                        this.monitor.subTask(transStr);
                        ArtifactId commitArtId = TransactionManager.getCommitArtifact((TransactionId)transactionId);
                        if (!commitArtId.isValid()) continue;
                        Artifact assocArt = ArtifactQuery.getArtifactFromId((ArtifactId)commitArtId, (BranchId)CoreBranches.COMMON);
                        if (!assocArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) continue;
                        TeamWorkFlowArtifact twf = (TeamWorkFlowArtifact)assocArt;
                        this.rd.addRaw(AHTML.addRowMultiColumnTable((String[])new String[]{assocArt.getArtifactTypeName(), "Committed", twf.getAtsId(), twf.getName()}));
                        committedChanges = true;
                    }
                }
                if (!committedChanges) {
                    this.rd.addRaw(AHTML.addRowSpanMultiColumnTable((String)"No Impacting Actions Found", (int)3));
                }
                this.rd.addRaw(AHTML.endMultiColumnTable());
            }
        }
    }
}

