/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.ev;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.ide.ev.WorkPackageData;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;

public class WorkPackageConfigLoader {
    public Map<String, Artifact> workPackageGuidToWorkPackageArt;
    public Map<Artifact, Artifact> workPackageArtToActivityArt;
    public Map<Artifact, Artifact> activityArtToInsertionArt;
    public Map<Artifact, Artifact> insertionArtToProgramArt;
    public Map<Artifact, Artifact> programArtToCountryArt;
    public Map<String, WorkPackageData> workPackageGuidToWorkPackageData;

    public void load() {
        this.workPackageGuidToWorkPackageArt = new HashMap<String, Artifact>();
        this.workPackageArtToActivityArt = new HashMap<Artifact, Artifact>();
        this.activityArtToInsertionArt = new HashMap<Artifact, Artifact>();
        this.insertionArtToProgramArt = new HashMap<Artifact, Artifact>();
        this.programArtToCountryArt = new HashMap<Artifact, Artifact>();
        this.workPackageGuidToWorkPackageData = new HashMap<String, WorkPackageData>();
        this.loadWorkPackageConfiguration();
        for (Artifact workPackageArt : ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)AtsArtifactTypes.WorkPackage, (BranchId)AtsApiService.get().getAtsBranch())) {
            this.workPackageGuidToWorkPackageArt.put(workPackageArt.getGuid(), workPackageArt);
            WorkPackageData data = new WorkPackageData(workPackageArt.getName(), workPackageArt.getId());
            Artifact insertionActivityArt = this.workPackageArtToActivityArt.get(workPackageArt);
            if (insertionActivityArt != null) {
                this.workPackageArtToActivityArt.put(workPackageArt, insertionActivityArt);
                data.setInsertionActivityName(insertionActivityArt.getName());
                Artifact insertionArt = this.activityArtToInsertionArt.get(insertionActivityArt);
                insertionActivityArt.getRelatedArtifactOrNull(AtsRelationTypes.InsertionToInsertionActivity_Insertion);
                if (insertionArt != null) {
                    data.setInsertionName(insertionArt.getName());
                    Artifact programArt = this.insertionArtToProgramArt.get(insertionArt);
                    if (programArt != null) {
                        data.setProgramName(programArt.getName());
                        Artifact countryArt = this.programArtToCountryArt.get(programArt);
                        if (countryArt != null) {
                            data.setCountryName(countryArt.getName());
                        }
                    }
                }
            }
            data.setWorkPackageProgram(workPackageArt.getSoleAttributeValueAsString((AttributeTypeToken)AtsAttributeTypes.WorkPackageProgram, ""));
            data.setWorkPackageIdStr((String)workPackageArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.WorkPackageId, (Object)""));
            data.setActivityId((String)workPackageArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.ActivityId, (Object)""));
            data.setWorkPackageType((String)workPackageArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.WorkPackageType, (Object)""));
            data.setWorkPackageNotes((String)workPackageArt.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Notes, (Object)""));
            data.setWorkPackageAnnotation((String)workPackageArt.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Annotation, (Object)""));
            data.setTeamNames(Collections.toString((String)"; ", (Iterable)workPackageArt.getRelatedArtifacts(AtsRelationTypes.TeamDefinitionToWorkPackage_AtsTeamDefOrAi)));
            data.setWorkPackageActive((Boolean)workPackageArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Active, (Object)false));
            data.setWorkPackageStartDate((Date)workPackageArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.StartDate, null));
            data.setWorkPackageEndDate((Date)workPackageArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.EndDate, null));
            data.setWorkPackagePercentComplete((Integer)workPackageArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.PercentComplete, (Object)0));
            data.setWorkPackagePointsNumeric((Double)workPackageArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.PointsNumeric, (Object)0.0));
            this.workPackageGuidToWorkPackageData.put(workPackageArt.getGuid(), data);
        }
    }

    private void loadWorkPackageConfiguration() {
        for (Artifact workPackageArt : ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)AtsArtifactTypes.WorkPackage, (BranchId)AtsApiService.get().getAtsBranch())) {
            Artifact insertionActivityArt = workPackageArt.getRelatedArtifactOrNull(AtsRelationTypes.InsertionActivityToWorkPackage_InsertionActivity);
            if (insertionActivityArt == null) continue;
            this.workPackageArtToActivityArt.put(workPackageArt, insertionActivityArt);
            Artifact insertionArt = insertionActivityArt.getRelatedArtifactOrNull(AtsRelationTypes.InsertionToInsertionActivity_Insertion);
            if (insertionArt == null) continue;
            this.activityArtToInsertionArt.put(insertionActivityArt, insertionArt);
            Artifact programArt = insertionArt.getRelatedArtifactOrNull(AtsRelationTypes.ProgramToInsertion_Program);
            if (programArt == null) continue;
            this.insertionArtToProgramArt.put(insertionArt, programArt);
            Artifact countryArt = programArt.getRelatedArtifactOrNull(AtsRelationTypes.CountryToProgram_Country);
            if (countryArt == null) continue;
            this.programArtToCountryArt.put(programArt, countryArt);
        }
    }

    public Collection<WorkPackageData> getWorkPackageDatas() {
        return this.workPackageGuidToWorkPackageData.values();
    }

    public WorkPackageData getWorkPackageData(String workPackageGuid) {
        return this.workPackageGuidToWorkPackageData.get(workPackageGuid);
    }
}

