/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.widget;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workdef.StateDefinitionLabelProvider;
import org.eclipse.osee.ats.ide.workdef.StateDefinitionViewSorter;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XComboViewer;
import org.eclipse.swt.widgets.Composite;

public class XTransitionToStateComboWidget
extends XComboViewer
implements ArtifactWidget {
    private Artifact artifact;
    private AbstractWorkflowArtifact awa;

    public XTransitionToStateComboWidget() {
        this("Transition To State Combo");
        this.setDisplayLabel(false);
    }

    public XTransitionToStateComboWidget(String displayLabel) {
        super(displayLabel, 0);
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        if (this.artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact})) {
            this.awa = (AbstractWorkflowArtifact)this.artifact;
            ArrayList<StateDefinition> states = new ArrayList<StateDefinition>();
            for (StateDefinition nextState : AtsApiService.get().getWorkItemService().getAllToStates((IAtsWorkItem)this.awa)) {
                if (states.contains(nextState)) continue;
                states.add(nextState);
            }
            this.setInput(states);
            this.setLabelProvider(new StateDefinitionLabelProvider());
            this.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.setComparator((ViewerComparator)new StateDefinitionViewSorter());
            super.createControls(parent, horizontalSpan);
            StateDefinition defaultToState = AtsApiService.get().getWorkItemService().getDefaultToState((IAtsWorkItem)this.awa);
            ArrayList<StateDefinition> defaultPage = new ArrayList<StateDefinition>();
            if (defaultToState != null) {
                defaultPage.add(defaultToState);
                this.setSelected(defaultPage);
            }
            if (this.awa.getStateDefinition().getStateType().isCancelledState() && Strings.isValid((String)this.awa.getCancelledFromState())) {
                defaultPage.add(this.awa.getStateDefinitionByName(this.awa.getCancelledFromState()));
                this.setSelected(defaultPage);
            }
            if (this.awa.getStateDefinition().getStateType().isCompletedState() && Strings.isValid((String)this.awa.getCompletedFromState())) {
                defaultPage.add(this.awa.getStateDefinitionByName(this.awa.getCompletedFromState()));
                this.setSelected(defaultPage);
            }
            this.getCombo().setVisibleItemCount(20);
        }
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void saveToArtifact() {
    }

    public void revert() {
    }

    public Result isDirty() {
        return Result.FalseResult;
    }
}

