/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.header;

import java.util.Collections;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.column.ev.WorkPackageColumnUI;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.PromptChangeUtil;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class WfeWorkPackage
extends Composite {
    private static final String WORK_PACKAGE = "Work Package:";
    Text valueLabel;
    Hyperlink link;
    private final IAtsTeamWorkflow teamWf;
    AtsApi atsApi;

    public WfeWorkPackage(Composite parent, int style, final IAtsTeamWorkflow teamWf, final WorkflowEditor editor) {
        super(parent, style);
        this.teamWf = teamWf;
        this.atsApi = AtsApiService.get();
        this.setLayoutData(new GridData());
        this.setLayout((Layout)ALayout.getZeroMarginLayout((int)2, (boolean)false));
        editor.getToolkit().adapt((Composite)this);
        try {
            this.link = editor.getToolkit().createHyperlink((Composite)this, WORK_PACKAGE, 0);
            if (!teamWf.isCancelled() && !teamWf.isCompleted()) {
                this.link.addHyperlinkListener(new IHyperlinkListener(){

                    public void linkEntered(HyperlinkEvent e) {
                    }

                    public void linkExited(HyperlinkEvent e) {
                    }

                    public void linkActivated(HyperlinkEvent e) {
                        try {
                            if (editor.isDirty()) {
                                editor.doSave(null);
                            }
                            if (WfeWorkPackage.this.atsApi.getEarnedValueService().isUseTextWorkPackages(Collections.singleton(teamWf))) {
                                PromptChangeUtil.promptChangeAttribute(Collections.singleton((AbstractWorkflowArtifact)teamWf.getStoreObject()), (AttributeTypeToken)AtsAttributeTypes.WorkPackage, true);
                            } else {
                                WorkPackageColumnUI.promptChangeActivityId((IAtsWorkItem)teamWf, true);
                            }
                        }
                        catch (Exception ex) {
                            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                        }
                    }
                });
            } else {
                this.link.setEnabled(false);
            }
            this.valueLabel = new Text((Composite)this, 8);
            this.valueLabel.setLayoutData((Object)new GridData());
            editor.getToolkit().adapt((Control)this.valueLabel, true, true);
            this.valueLabel.setText(Widgets.NOT_SET);
            this.refresh();
        }
        catch (OseeCoreException ex) {
            Label errorLabel = editor.getToolkit().createLabel((Composite)this, "Error: " + ex.getLocalizedMessage());
            errorLabel.setForeground(Displays.getSystemColor((int)3));
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public void refresh() {
        if (Widgets.isAccessible((Widget)this.valueLabel)) {
            String value = Widgets.NOT_SET;
            if (this.atsApi.getEarnedValueService().isUseTextWorkPackages(Collections.singleton(this.teamWf))) {
                value = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)this.teamWf, (AttributeTypeToken)AtsAttributeTypes.WorkPackage, (Object)"");
            } else {
                IAtsWorkPackage workPackage = this.atsApi.getEarnedValueService().getWorkPackage((IAtsWorkItem)this.teamWf);
                if (workPackage != null) {
                    value = workPackage.toString();
                }
            }
            this.valueLabel.setText(value);
            this.valueLabel.getParent().layout();
            this.valueLabel.getParent().getParent().layout();
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (Widgets.isAccessible((Widget)this.valueLabel)) {
            this.valueLabel.setBackground(color);
        }
        if (Widgets.isAccessible((Widget)this.link)) {
            this.link.setBackground(color);
        }
    }
}

