/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.header;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workflow.note.AtsStateNote;
import org.eclipse.osee.ats.api.workflow.note.AtsStateNoteType;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkLabelValueSelection;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class WfeStateNotesHeader
extends Composite {
    private final IAtsWorkItem workItem;
    private final WorkflowEditor editor;
    private final List<Composite> nComps = new ArrayList<Composite>();
    private final String forStateName;

    public WfeStateNotesHeader(Composite parent, int style, IAtsWorkItem workItem, String forStateName, WorkflowEditor editor) {
        super(parent, style);
        this.workItem = workItem;
        this.forStateName = forStateName;
        this.editor = editor;
        this.setLayoutData(new GridData(4, 0, true, false));
        this.setLayout((Layout)ALayout.getZeroMarginLayout((int)1, (boolean)false));
        editor.getToolkit().adapt((Composite)this);
        this.setBackground(Displays.getSystemColor((int)1));
        this.createNotes(workItem, forStateName, editor);
    }

    private void createNotes(final IAtsWorkItem workItem, String forStateName, WorkflowEditor editor) {
        try {
            List notes = AtsApiService.get().getWorkItemService().getStateNoteService().getNotes(workItem);
            for (final AtsStateNote note : notes) {
                if (forStateName != null && (note.getState() == null || !note.getState().equals(forStateName))) continue;
                Composite nComp = new Composite((Composite)this, 0);
                nComp.setLayoutData((Object)new GridData(4, 0, true, false));
                nComp.setLayout((Layout)ALayout.getZeroMarginLayout((int)2, (boolean)false));
                editor.getToolkit().adapt(nComp);
                this.nComps.add(nComp);
                Label iconLabel = editor.getToolkit().createLabel(nComp, "");
                if (AtsStateNoteType.Problem.name().equals(note.getType())) {
                    iconLabel.setImage(ImageManager.getImage((KeyedImage)FrameworkImage.ERROR));
                } else if (AtsStateNoteType.Warning.name().equals(note.getType())) {
                    iconLabel.setImage(ImageManager.getImage((KeyedImage)FrameworkImage.WARNING));
                } else {
                    iconLabel.setImage(ImageManager.getImage((KeyedImage)FrameworkImage.INFO_LG));
                }
                String hyperlinkStr = String.format("%sNote", Strings.isValid((String)note.getState()) ? String.valueOf(note.getState()) + " " : "");
                String labelStr = String.format("%s: %s - %s - [%s]", note.getType(), note.getUserName(), DateUtil.getMMDDYYHHMM((Date)note.getDateObj()), note.getMsg());
                final String shortStr = Strings.truncate((String)labelStr, (int)150).replaceAll("[\n\r]+", " ");
                XHyperlinkLabelValueSelection wid = new XHyperlinkLabelValueSelection(hyperlinkStr){

                    public String getCurrentValue() {
                        return shortStr;
                    }

                    public boolean handleSelection() {
                        EntryDialog ed = new EntryDialog(Displays.getActiveShell(), "View/Update State Note", null, "Enter State Notes", 3, new String[]{"Remove", "Update", "Cancel"}, 2);
                        ed.setFillVertically(true);
                        ed.setEntry(note.getMsg());
                        int result = ed.open();
                        if (result == 0) {
                            return AtsApiService.get().getWorkItemService().getStateNoteService().removeNote(workItem, note);
                        }
                        if (result == 1) {
                            return AtsApiService.get().getWorkItemService().getStateNoteService().updateNote(workItem, note, ed.getEntry());
                        }
                        return false;
                    }
                };
                wid.setEditable(true);
                wid.setToolTip("Select to View/Modify/Delete");
                wid.createWidgets(editor.getWorkFlowTab().getManagedForm(), nComp, 1);
            }
        }
        catch (OseeCoreException ex) {
            Label errorLabel = editor.getToolkit().createLabel((Composite)this, "Error: " + ex.getLocalizedMessage());
            errorLabel.setForeground(Displays.getSystemColor((int)3));
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public void refresh() {
        for (Composite comp : this.nComps) {
            if (!Widgets.isAccessible((Widget)comp)) continue;
            comp.dispose();
        }
        this.createNotes(this.workItem, this.forStateName, this.editor);
    }
}

