/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.header;

import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.PromptChangeUtil;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class WfeEstimatedHoursHeader
extends Composite {
    private static final String LABEL = "Estimated Hours:";
    private final String LABEL_TOOL_TIP = "[Workflow Estimate] | [Calculation: Sum estimated hours for workflow and all tasks and reviews]";
    private final String LINK_TOOL_TIP = "Select to set estimated number of hours to complete workflow and concomitant tasks/review.";
    Label valueLabel;
    private final IAtsWorkItem workItem;

    public WfeEstimatedHoursHeader(Composite parent, int style, final IAtsWorkItem workItem, final WorkflowEditor editor) {
        super(parent, style);
        this.workItem = workItem;
        this.setLayoutData(new GridData(4, 0, true, false));
        this.setLayout((Layout)ALayout.getZeroMarginLayout((int)2, (boolean)false));
        try {
            if (!workItem.isCancelled() && !workItem.isCompleted()) {
                Hyperlink link = editor.getToolkit().createHyperlink((Composite)this, LABEL, 0);
                link.setToolTipText("Select to set estimated number of hours to complete workflow and concomitant tasks/review.");
                link.addHyperlinkListener(new IHyperlinkListener(){

                    public void linkEntered(HyperlinkEvent e) {
                    }

                    public void linkExited(HyperlinkEvent e) {
                    }

                    public void linkActivated(HyperlinkEvent e) {
                        try {
                            if (editor.isDirty()) {
                                editor.doSave(null);
                            }
                            PromptChangeUtil.promptChangeAttribute(workItem, (AttributeTypeToken)AtsAttributeTypes.EstimatedHours, true);
                        }
                        catch (Exception ex) {
                            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                        }
                    }
                });
            } else {
                Label origLabel = editor.getToolkit().createLabel((Composite)this, LABEL);
                origLabel.setLayoutData((Object)new GridData());
            }
            this.valueLabel = editor.getToolkit().createLabel((Composite)this, "0.0");
            this.valueLabel.setToolTipText("[Workflow Estimate] | [Calculation: Sum estimated hours for workflow and all tasks and reviews]");
            this.valueLabel.setLayoutData((Object)new GridData());
            this.refresh();
        }
        catch (OseeCoreException ex) {
            Label errorLabel = editor.getToolkit().createLabel((Composite)this, "Error: " + ex.getLocalizedMessage());
            errorLabel.setForeground(Displays.getSystemColor((int)3));
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    private String getEstHoursStr() {
        double totalEst = 0.0;
        double awaEst = (Double)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.EstimatedHours, (Object)0.0);
        if (awaEst < 0.0) {
            OseeLog.log(((Object)((Object)this)).getClass(), (Level)OseeLevel.SEVERE_POPUP, (String)"Negative estimated hours not allowed.  Please set to the expected estimated hours.");
            PromptChangeUtil.promptChangeAttribute(this.workItem, (AttributeTypeToken)AtsAttributeTypes.EstimatedHours, true);
        } else {
            totalEst = AtsApiService.get().getEarnedValueService().getEstimatedHoursTotal(this.workItem);
        }
        if (awaEst != totalEst) {
            return String.format("%s | %s", AtsUtil.doubleToI18nString((double)awaEst), AtsUtil.doubleToI18nString((double)totalEst));
        }
        return AtsUtil.doubleToI18nString((double)awaEst);
    }

    public void refresh() {
        this.valueLabel.setText(this.getEstHoursStr());
        this.valueLabel.getParent().getParent().layout();
    }
}

