/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.header;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;

public class WfeEditorAddSupportingArtifacts
extends Job {
    private final Collection<Artifact> supportingArtifacts;
    private final IAtsWorkItem workItem;

    public WfeEditorAddSupportingArtifacts(IAtsWorkItem workItem, Collection<Artifact> supportingArtifacts) {
        super("Add Supporting Artifacts");
        this.workItem = workItem;
        this.supportingArtifacts = supportingArtifacts;
    }

    public XResultData validate() {
        XResultData results = new XResultData();
        if (this.supportingArtifacts.isEmpty()) {
            results.error("Must pass in supporting artifacts");
        }
        for (Artifact art : this.supportingArtifacts) {
            if (art.isOnBranch((BranchId)AtsApiService.get().getAtsBranch())) continue;
            results.error("Can not relate artifacts that are not on the ATS Branch");
        }
        return results;
    }

    public IStatus run(IProgressMonitor monitor) {
        XResultData results = this.validate();
        if (results.isErrors()) {
            throw new OseeArgumentException(results.toString(), new Object[0]);
        }
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("Related supporting artifacts");
        for (Artifact art : this.supportingArtifacts) {
            if (AtsApiService.get().getRelationResolver().areRelated((ArtifactId)this.workItem.getStoreObject(), CoreRelationTypes.SupportingInfo_SupportingInfo, (ArtifactId)art)) continue;
            changes.relate((Object)this.workItem, CoreRelationTypes.SupportingInfo_SupportingInfo, (Object)art);
        }
        if (changes.isEmpty()) {
            AWorkbench.popup((String)"Nothing to relate");
        } else {
            changes.execute();
        }
        return Status.OK_STATUS;
    }
}

