/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.defects;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.ide.util.widgets.defect.DefectUtil;
import org.eclipse.osee.ats.ide.util.widgets.defect.DefectXViewer;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class WfeDefectsToolbar {
    private final ScrolledForm scrolledForm;
    private final IAtsPeerToPeerReview review;
    private final DefectXViewer defectXViewer;
    private DefectUtil defectUtil;
    private Action importDefectsAction;

    public WfeDefectsToolbar(ScrolledForm scrolledForm, DefectXViewer defectXViewer, IAtsPeerToPeerReview review) {
        this.scrolledForm = scrolledForm;
        this.defectXViewer = defectXViewer;
        this.review = review;
    }

    public DefectUtil getDefectUtil() {
        if (this.defectUtil == null) {
            this.defectUtil = new DefectUtil(this.defectXViewer, this.review);
        }
        return this.defectUtil;
    }

    public void build() {
        IToolBarManager toolBarMgr = this.scrolledForm.getToolBarManager();
        toolBarMgr.removeAll();
        toolBarMgr.add((IAction)new NewDefectAction());
        toolBarMgr.add((IAction)new DeleteDefectAction());
        toolBarMgr.add((IContributionItem)new Separator());
        toolBarMgr.add((IAction)this.defectXViewer.getCustomizeAction());
        this.createDropDownMenuActions();
        toolBarMgr.add((IAction)new DropDownAction());
        toolBarMgr.add((IContributionItem)new Separator());
        this.scrolledForm.updateToolBar();
    }

    private void createDropDownMenuActions() {
        this.importDefectsAction = new Action("Import Defects from Simple List", 1){

            public void run() {
                WfeDefectsToolbar.this.getDefectUtil().handleImportDefectsViaList();
            }
        };
        this.importDefectsAction.setImageDescriptor(ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.IMPORT));
    }

    private class DeleteDefectAction
    extends Action {
        private DeleteDefectAction() {
        }

        public void run() {
            WfeDefectsToolbar.this.getDefectUtil().handleDeleteDefect(true);
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.X_RED);
        }

        public String getText() {
            return "Delete Defect";
        }

        public boolean isEnabled() {
            return WfeDefectsToolbar.this.review.isInWork();
        }
    }

    public class DropDownAction
    extends Action
    implements IMenuCreator {
        private Menu fMenu;

        public DropDownAction() {
            this.setText("Other");
            this.setMenuCreator(this);
            this.setImageDescriptor(ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.GEAR));
        }

        public Menu getMenu(Control parent) {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
            this.fMenu = new Menu(parent);
            this.addActionToMenu(this.fMenu, WfeDefectsToolbar.this.importDefectsAction);
            return this.fMenu;
        }

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
                this.fMenu = null;
            }
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        protected void addActionToMenu(Menu parent, Action action) {
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(parent, -1);
        }

        void clear() {
            this.dispose();
        }
    }

    private class NewDefectAction
    extends Action {
        private NewDefectAction() {
        }

        public void run() {
            WfeDefectsToolbar.this.getDefectUtil().handleNewDefect();
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.GREEN_PLUS);
        }

        public String getText() {
            return "New Defect";
        }

        public boolean isEnabled() {
            return WfeDefectsToolbar.this.review.isInWork();
        }
    }
}

