/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.bit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.config.JaxTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.cr.bit.model.BuildImpactData;
import org.eclipse.osee.ats.api.workflow.cr.bit.model.BuildImpactDatas;
import org.eclipse.osee.ats.ide.editor.tab.bit.XBitXViewerFactory;
import org.eclipse.osee.ats.ide.editor.tab.bit.action.HandleBitConfigChange;
import org.eclipse.osee.ats.ide.editor.tab.bit.action.HandleBitStateChange;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.task.TaskXViewer;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.ArtifactDoubleClick;
import org.eclipse.osee.framework.ui.swt.IDirtiableEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class XBitViewer
extends TaskXViewer {
    protected final IAtsTeamWorkflow crTeamWf;
    protected final AtsApi atsApi = AtsApiService.get();
    private BuildImpactDatas bids;

    public XBitViewer(Composite parent, int style, IXViewerFactory xViewerFactory, IDirtiableEditor editor, IAtsTeamWorkflow teamWf) {
        super(parent, style, xViewerFactory, editor, teamWf);
        this.crTeamWf = teamWf;
    }

    public List<BuildImpactData> getSelectedBuildImpactDatas() {
        ArrayList<BuildImpactData> bids = new ArrayList<BuildImpactData>();
        TreeItem[] items = this.getTree().getSelection();
        if (items.length > 0) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (item.getData() instanceof BuildImpactData) {
                    BuildImpactData bid = (BuildImpactData)item.getData();
                    bids.add(bid);
                }
                ++n2;
            }
        }
        return bids;
    }

    @Override
    public List<Artifact> getSelectedArtifacts() {
        ArrayList<Artifact> arts = new ArrayList<Artifact>();
        TreeItem[] items = this.getTree().getSelection();
        if (items.length > 0) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (item.getData() instanceof JaxTeamWorkflow) {
                    JaxTeamWorkflow jTeamWf = (JaxTeamWorkflow)item.getData();
                    Long id = jTeamWf.getId();
                    Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact(id);
                    if (artifact != null) {
                        arts.add(artifact);
                    }
                } else if (item.getData() instanceof BuildImpactData) {
                    BuildImpactData bid = (BuildImpactData)item.getData();
                    Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact((ArtifactId)bid.getBidArt());
                    if (artifact != null) {
                        arts.add(artifact);
                    }
                }
                ++n2;
            }
        }
        return arts;
    }

    @Override
    public Set<Artifact> getSelectedWorkflowArtifacts() {
        HashSet<Artifact> smaArts = new HashSet<Artifact>();
        for (Artifact art : this.getSelectedArtifacts()) {
            if (!(art instanceof AbstractWorkflowArtifact)) continue;
            smaArts.add(art);
        }
        return smaArts;
    }

    public void loadTable() {
        try {
            if (this.getContentProvider() != null) {
                this.setInput(this.bids);
                this.setLoading(false);
                this.refresh();
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    @Override
    public void handleDoubleClick() {
        Collection artifacts = this.getSelectedArtifacts();
        if (!artifacts.isEmpty()) {
            ArtifactDoubleClick.open((Artifact)((Artifact)artifacts.iterator().next()));
        }
    }

    public BuildImpactDatas getBids() {
        return this.bids;
    }

    public void setBids(BuildImpactDatas bids) {
        this.bids = bids;
    }

    @Override
    protected boolean showTaskMenu() {
        return false;
    }

    @Override
    public boolean isRemoveItemsMenuOptionEnabled() {
        return false;
    }

    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        if (treeItem.getData() instanceof BuildImpactData) {
            BuildImpactData bid = (BuildImpactData)treeItem.getData();
            if (treeColumn.getText().equals(XBitXViewerFactory.State_Col.getName())) {
                new HandleBitStateChange(this.crTeamWf, this, this.atsApi).handleChangeState(bid);
            } else if (treeColumn.getText().equals(XBitXViewerFactory.Config_Col.getName())) {
                new HandleBitConfigChange(this, this.atsApi).handleChangeConfig(bid);
            }
        }
        return false;
    }

    @Override
    protected boolean isAddTaskEnabled() {
        return false;
    }

    @Override
    public boolean isColumnMultiEditable(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        if (!(treeColumn.getData() instanceof XViewerColumn)) {
            return false;
        }
        return ((XViewerColumn)treeColumn.getData()).isMultiColumnEditable();
    }

    @Override
    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        if (treeColumn.getText().equals(XBitXViewerFactory.State_Col.getName())) {
            new HandleBitStateChange(this.crTeamWf, this, this.atsApi).handleMultiEdit();
        }
    }

    @Override
    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems, boolean persist) {
        super.handleColumnMultiEdit(treeColumn, treeItems);
    }
}

