/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.workflow.WorkflowManager;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

public class PercentCompleteStateReviewColumn
extends XViewerAtsColumn
implements IXViewerValueColumn {
    public static PercentCompleteStateReviewColumn instance = new PercentCompleteStateReviewColumn();

    public static PercentCompleteStateReviewColumn getInstance() {
        return instance;
    }

    private PercentCompleteStateReviewColumn() {
        super("ats.column.stateReviewPercentComplete", "State Review Percent Complete", 40, XViewerAlign.Center, false, SortDataType.Percent, false, "Percent Complete for the reviews related to the current state.\n\nCalculation: total percent of all reviews related to state / number of reviews related to state");
    }

    public PercentCompleteStateReviewColumn copy() {
        PercentCompleteStateReviewColumn newXCol = new PercentCompleteStateReviewColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        try {
            if (element instanceof Artifact) {
                return String.valueOf(PercentCompleteStateReviewColumn.getPercentCompleteStateReview(AtsApiService.get().getQueryServiceIde().getArtifact(element)));
            }
        }
        catch (OseeCoreException ex) {
            return LogUtil.getCellExceptionString((Exception)((Object)ex));
        }
        return "";
    }

    public static int getPercentCompleteStateReview(Artifact artifact) {
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
            double percent = 0.0;
            for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams((Object)artifact)) {
                if (team.isCancelled()) continue;
                percent += (double)PercentCompleteStateReviewColumn.getPercentCompleteStateReview(AtsApiService.get().getQueryServiceIde().getArtifact(team));
            }
            if (percent == 0.0) {
                return 0;
            }
            Double rollPercent = percent / (double)AtsApiService.get().getWorkItemService().getTeams((Object)artifact).size();
            return rollPercent.intValue();
        }
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact})) {
            return PercentCompleteStateReviewColumn.getPercentCompleteStateReview(artifact, WorkflowManager.getStateManager(artifact).getCurrentState());
        }
        return 0;
    }

    public static int getPercentCompleteStateReview(Artifact artifact, IStateToken state) {
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
            return AtsApiService.get().getEarnedValueService().getPercentCompleteFromReviews((IAtsWorkItem)((TeamWorkFlowArtifact)artifact), state);
        }
        return 0;
    }
}

