/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Collection;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

public class PercentCompleteReviewsColumn
extends XViewerAtsColumn
implements IXViewerValueColumn {
    public static PercentCompleteReviewsColumn instance = new PercentCompleteReviewsColumn();

    public static PercentCompleteReviewsColumn getInstance() {
        return instance;
    }

    private PercentCompleteReviewsColumn() {
        super("ats.column.reviewPercentComplete", "Review Percent Complete", 40, XViewerAlign.Center, false, SortDataType.Percent, false, "Percent Complete for the reviews.\n\nCalculation: total percent of all reviews / number of reviews");
    }

    public PercentCompleteReviewsColumn copy() {
        PercentCompleteReviewsColumn newXCol = new PercentCompleteReviewsColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        try {
            IAtsWorkItem workItem;
            if (element instanceof IAtsWorkItem && (workItem = (IAtsWorkItem)element).isTeamWorkflow()) {
                return String.valueOf(PercentCompleteReviewsColumn.getPercentCompleteReview(AtsApiService.get().getQueryServiceIde().getArtifact(element)));
            }
        }
        catch (OseeCoreException ex) {
            return LogUtil.getCellExceptionString((Exception)((Object)ex));
        }
        return "";
    }

    public static int getPercentCompleteReview(Artifact artifact) {
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
            double percent = 0.0;
            for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams((Object)artifact)) {
                if (team.isCancelled()) continue;
                percent += (double)PercentCompleteReviewsColumn.getPercentCompleteReview(AtsApiService.get().getQueryServiceIde().getArtifact(team));
            }
            if (percent == 0.0) {
                return 0;
            }
            Double rollPercent = percent / (double)AtsApiService.get().getWorkItemService().getTeams((Object)artifact).size();
            return rollPercent.intValue();
        }
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
            int spent = 0;
            Collection reviews = AtsApiService.get().getReviewService().getReviews((IAtsTeamWorkflow)((TeamWorkFlowArtifact)artifact));
            for (IAtsAbstractReview review : reviews) {
                spent += AtsApiService.get().getWorkItemMetricsService().getPercentCompleteTotal((IAtsObject)review);
            }
            if (spent == 0) {
                return 0;
            }
            return spent / reviews.size();
        }
        return 0;
    }
}

