/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

public class DaysInCurrentStateColumn
extends XViewerAtsColumn
implements IXViewerValueColumn {
    public static DaysInCurrentStateColumn instance = new DaysInCurrentStateColumn();

    public static DaysInCurrentStateColumn getInstance() {
        return instance;
    }

    private DaysInCurrentStateColumn() {
        super("ats.column.daysInCurrState", "Days in Current State", 40, XViewerAlign.Center, false, SortDataType.Float, false, null);
    }

    public DaysInCurrentStateColumn copy() {
        DaysInCurrentStateColumn newXCol = new DaysInCurrentStateColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        try {
            if (element instanceof AbstractWorkflowArtifact) {
                double timeInCurrState = ((AbstractWorkflowArtifact)((Object)element)).getStateMgr().getTimeInState();
                if (timeInCurrState != 0.0) return AtsUtil.doubleToI18nString((double)(timeInCurrState / 8.64E7));
                return "0.0";
            }
            if (!Artifacts.isOfType((Object)element, (ArtifactTypeToken)AtsArtifactTypes.Action)) return "";
            HashSet<String> strs = new HashSet<String>();
            Iterator iterator = AtsApiService.get().getWorkItemService().getTeams(element).iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return Collections.toString((String)", ", strs);
                }
                IAtsTeamWorkflow team = (IAtsTeamWorkflow)iterator.next();
                String str = this.getColumnText(team, column, columnIndex);
                if (!Strings.isValid((String)str)) continue;
                strs.add(str);
            }
        }
        catch (OseeCoreException ex) {
            LogUtil.getCellExceptionString((Exception)((Object)ex));
        }
        return "";
    }
}

