/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.ide.actions.AbstractAtsAction;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeString;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractEditSubStatusAction
extends AbstractAtsAction {
    private final ISelectedAtsArtifacts selectedAtsArtifacts;
    private final AttributeTypeString attrType;
    private final String positive;
    private final String negative;

    public AbstractEditSubStatusAction(ISelectedAtsArtifacts selectedAtsArtifacts, String positive, String negative, FrameworkImage image, AttributeTypeString attrType) {
        super(String.valueOf(positive) + "/" + negative + " Workflow", selectedAtsArtifacts);
        this.selectedAtsArtifacts = selectedAtsArtifacts;
        this.attrType = attrType;
        this.positive = positive;
        this.negative = negative;
        this.setImageDescriptor(ImageManager.getImageDescriptor((KeyedImage)image));
    }

    @Override
    public void runWithException() {
        boolean setWorkflow = false;
        boolean prompt = false;
        boolean fetchedStatus = false;
        String reason = "";
        for (Artifact workItemArt : this.selectedAtsArtifacts.getSelectedWorkflowArtifacts()) {
            IAtsChangeSet changes = AtsApiService.get().createChangeSet("Set " + this.positive + " status");
            if (!fetchedStatus) {
                reason = (String)workItemArt.getSoleAttributeValue((AttributeTypeId)this.attrType, (Object)"");
                IAtsWorkItem workItem = AtsApiService.get().getWorkItemService().getWorkItem((ArtifactToken)workItemArt);
                if (reason.equals("")) {
                    setWorkflow = true;
                    EntryDialog ed = new EntryDialog("Setting Workflow to " + this.positive, "Enter the reason to set this workflow to " + this.positive);
                    if (ed.open() == 0 && !Strings.isValid((String)(reason = ed.getEntry()))) {
                        reason = this.getSubStatusReason(workItem);
                    }
                }
                if (reason.isEmpty() && this.getSubStatusReason(workItem).isEmpty()) {
                    return;
                }
                fetchedStatus = true;
            }
            if (setWorkflow) {
                changes.setSoleAttributeValue((ArtifactId)workItemArt, (AttributeTypeToken)this.attrType, (Object)(String.valueOf(this.positive) + " - " + reason));
            } else {
                if (!prompt) {
                    if (!MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)(String.valueOf(this.negative) + " Workflow"), (String)("Are you sure you wish to set this workflow to " + this.negative + "?"))) {
                        return;
                    }
                    prompt = true;
                }
                changes.deleteAttributes((ArtifactId)workItemArt, (AttributeTypeToken)this.attrType);
            }
            changes.executeIfNeeded();
        }
    }

    private String getSubStatusReason(IAtsWorkItem workItem) {
        return (String)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)this.attrType, (Object)"");
    }
}

