/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.core.column.ActionableItemsColumn;
import org.eclipse.osee.ats.core.column.AtsIdColumn;
import org.eclipse.osee.ats.core.column.TeamColumn;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.AtsNavigateViewItems;
import org.eclipse.osee.ats.ide.util.widgets.XActionableItemCombo;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.XCheckBox;
import org.eclipse.osee.framework.ui.skynet.widgets.XListDropViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.builder.XWidgetBuilder;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetRendererItem;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RealignActionableItemsBlam
extends AbstractBlam {
    private final AtsApi atsApi = AtsApiService.get();
    private static final String ACTIONABLE_ITEMS_FROM = "Actionable Item(s) From";
    private static final String ACTIONABLE_ITEM_TO = "Actionable Item To";
    private static final String PERSIST = "Persist? (Read Description before checking the box)";
    private static final String DELETE = "Delete? (Read Description before checking the box)";
    private XActionableItemCombo xActionableItemCombo;
    private XListDropViewer xListDropViewer;
    private XCheckBox xPersistCheckBox;
    private XCheckBox xDeleteCheckBox;

    public String getName() {
        return "Realign Actionable Items for actions";
    }

    public List<XWidgetRendererItem> getXWidgetItems() {
        XWidgetBuilder wb = new XWidgetBuilder();
        wb.andWidget(ACTIONABLE_ITEMS_FROM, "XListDropViewer").endWidget();
        wb.andWidget(ACTIONABLE_ITEM_TO, "XActionableItemCombo").endWidget();
        wb.andWidget(PERSIST, "XCheckBox").endWidget();
        wb.andWidget(DELETE, "XCheckBox").endWidget();
        return wb.getItems();
    }

    private IAtsActionableItem getSelectedActionableItemTo() {
        return this.xActionableItemCombo.getSelectedAi();
    }

    private Collection<ArtifactToken> getActionableItemsFrom() {
        List actionableItemsFrom = Collections.castAll((Collection)this.xListDropViewer.getArtifacts());
        Conditions.checkNotNullOrEmpty((Collection)actionableItemsFrom, (String)ACTIONABLE_ITEMS_FROM);
        return actionableItemsFrom;
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Realign Actionable Items for actions", -1);
        Collection<ArtifactToken> actionableItemsFrom = this.getActionableItemsFrom();
        IAtsActionableItem actionableItemTo = this.getSelectedActionableItemTo();
        boolean isPersistAllowed = variableMap.getBoolean(PERSIST);
        boolean isDeleteAllowed = variableMap.getBoolean(DELETE);
        if (actionableItemTo.isValid() && actionableItemTo.getTeamDefinition() != null) {
            this.realignAiAndTdForActionsIfAllowed(actionableItemsFrom, actionableItemTo, isPersistAllowed, isDeleteAllowed);
        } else {
            StringBuilder err = new StringBuilder();
            err.append("Selected Actionable Item To: " + actionableItemTo.toString());
            err.append(" Or Related Team Definition: " + actionableItemTo.getTeamDefinition());
            err.append(" NOT VALID");
            this.log(new String[]{err.toString()});
        }
        monitor.done();
    }

    private void realignAiAndTdForActionsIfAllowed(Collection<ArtifactToken> actionableItemsFrom, IAtsActionableItem actionableItemTo, boolean isPersistAllowed, boolean isDeleteAllowed) {
        IAtsChangeSet changes = this.atsApi.createChangeSet("Realign AI/TD References for actions");
        List teamWfs = this.atsApi.getQueryService().getArtifactsFromAttributeValues((AttributeTypeId)AtsAttributeTypes.ActionableItemReference, actionableItemsFrom, (BranchId)CoreBranches.COMMON);
        List aiIdsFrom = actionableItemsFrom.stream().map(Id::getId).collect(Collectors.toList());
        final XResultData resultData = new XResultData();
        resultData.addRaw(this.getName());
        resultData.addRaw("\n Related actions counts: " + teamWfs.size() + "\n");
        resultData.addRaw(AHTML.beginMultiColumnTable((int)0, (int)1));
        String[] titleRow = new String[]{"Action Title", "Id", "AI From", "AI To", "TD From", "TD To"};
        resultData.addRaw(AHTML.addHeaderRowMultiColumnTable((String[])titleRow));
        for (ArtifactToken teamWf : teamWfs) {
            new ActionableItemsColumn(this.atsApi);
            Collection currentlyAssignedAIs = ActionableItemsColumn.getActionableItems((IAtsObject)((IAtsObject)teamWf));
            String currentlyAssignedTD = new TeamColumn(this.atsApi).getColumnText((IAtsObject)teamWf);
            String currentlyAssignedAtsId = new AtsIdColumn(this.atsApi).getColumnText((IAtsObject)teamWf);
            resultData.addRaw(AHTML.addRowMultiColumnTable((String[])new String[]{teamWf.getName(), currentlyAssignedAtsId, Collections.toString((String)", ", (Iterable)currentlyAssignedAIs), actionableItemTo.getName(), currentlyAssignedTD, actionableItemTo.getTeamDefinition().getName()}));
            if (!isPersistAllowed || resultData.isErrors()) continue;
            try {
                ArrayList<IAtsActionableItem> assignAIsTo = new ArrayList<IAtsActionableItem>();
                assignAIsTo.add(actionableItemTo);
                for (IAtsActionableItem currentlyAssignedAI : currentlyAssignedAIs) {
                    if (aiIdsFrom.contains(currentlyAssignedAI.getId())) continue;
                    assignAIsTo.add(currentlyAssignedAI);
                }
                changes.setAttributeValues((ArtifactId)teamWf, (AttributeTypeToken)AtsAttributeTypes.ActionableItemReference, assignAIsTo);
                if (this.atsApi.getAttributeResolver().getAttributeCount((ArtifactId)teamWf, (AttributeTypeToken)AtsAttributeTypes.TeamDefinitionReference) <= 0) continue;
                changes.setSoleAttributeValue((ArtifactId)teamWf, (AttributeTypeToken)AtsAttributeTypes.TeamDefinitionReference, (Object)actionableItemTo.getTeamDefinition());
            }
            catch (Exception ex) {
                resultData.errorf(ex.toString(), new Object[0]);
                resultData.errorf("%s - %s has unknown problem.\n", new Object[]{currentlyAssignedAtsId, teamWf.getName()});
            }
        }
        if (isDeleteAllowed && isPersistAllowed && !resultData.isErrors()) {
            for (ArtifactToken actionableItemFrom : actionableItemsFrom) {
                changes.deleteArtifact((ArtifactId)actionableItemFrom);
            }
            changes.executeIfNeeded();
        } else if (isPersistAllowed && !resultData.isErrors()) {
            changes.executeIfNeeded();
        }
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                XResultDataUI.report((XResultData)resultData, (String)("Results for " + RealignActionableItemsBlam.this.getName()));
            }
        });
    }

    public String getDescriptionUsage() {
        StringBuilder description = new StringBuilder();
        description.append("This BLAM will realign items that are associated with the dragged/dropped ");
        description.append("\"Actionable Item(s) From\" to the selected \"Actionable Item To\". ");
        description.append("Team Definition will get realign to the related Team Definition of the selected \"Actionable Item To\". ");
        description.append("It will re-assign team workflows to the selected \"Actionable Item To\" and related Team Definition. ");
        description.append("\n Note: Run BLAM without checking the persist and delete checkboxes first. It will generate report. ");
        description.append("If report data looks correct, then check the persist and delete checkboxes and run the BLAM to execute changes. ");
        description.append("\n Warning: When delete checkbox is checked, it will delete \"Actionable Item(s) From\" from OSEE. ");
        return description.toString();
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener modListener, boolean isEditable) {
        super.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, modListener, isEditable);
        if (xWidget.getLabel().equals(ACTIONABLE_ITEM_TO)) {
            this.xActionableItemCombo = (XActionableItemCombo)xWidget;
        } else if (xWidget.getLabel().equals(ACTIONABLE_ITEMS_FROM)) {
            this.xListDropViewer = (XListDropViewer)xWidget;
        } else if (xWidget.getLabel().equals(PERSIST)) {
            this.xPersistCheckBox = (XCheckBox)xWidget;
            this.xPersistCheckBox.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget) {
                    if (RealignActionableItemsBlam.this.xPersistCheckBox.isSelected()) {
                        RealignActionableItemsBlam.this.xDeleteCheckBox.setEditable(true);
                    } else {
                        RealignActionableItemsBlam.this.xDeleteCheckBox.setEditable(false);
                    }
                }
            });
        } else if (xWidget.getLabel().equals(DELETE)) {
            this.xDeleteCheckBox = (XCheckBox)xWidget;
            this.xDeleteCheckBox.setEditable(false);
        }
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(AtsNavigateViewItems.ATS_ADMIN, XNavItemCat.OSEE_ADMIN);
    }
}

