/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.util.UrlQuery;

public final class HttpUrlBuilder {
    private HttpUrlBuilder() {
    }

    public static UrlQuery getParametersFromUrl(String url) throws UnsupportedEncodingException {
        UrlQuery query = HttpUrlBuilder.createUrlQuery();
        return query.parse(url);
    }

    public static UrlQuery getParametersFromUrl(URL url) throws UnsupportedEncodingException {
        UrlQuery query = HttpUrlBuilder.createUrlQuery();
        return query.parse(url);
    }

    public static UrlQuery createUrlQuery() {
        return new UrlQuery();
    }

    public static String getParametersAsEncodedUrl(Map<String, String> keyValues) throws UnsupportedEncodingException {
        UrlQuery query = HttpUrlBuilder.createUrlQuery();
        for (Map.Entry<String, String> entry : keyValues.entrySet()) {
            query.put(entry.getKey(), entry.getValue());
        }
        return query.toUrl();
    }

    public static String createURL(URI uri, String context, Map<String, String> parameters) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append(uri.getScheme());
        sb.append("://");
        sb.append(uri.getHost());
        sb.append(":");
        sb.append(uri.getPort());
        sb.append("/");
        sb.append(context);
        if (parameters != null && !parameters.isEmpty()) {
            sb.append("?");
            sb.append(HttpUrlBuilder.getParametersAsEncodedUrl(parameters));
        }
        return sb.toString();
    }

    public static String createURL(String prefix, String context, Map<String, String> parameters) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        sb.append(context);
        if (parameters != null && !parameters.isEmpty()) {
            sb.append("?");
            sb.append(HttpUrlBuilder.getParametersAsEncodedUrl(parameters));
        }
        return sb.toString();
    }
}

