/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public final class EncryptUtility {
    private static final byte[] linebreak = new byte[0];
    private static final String TRANSFORMATION = "AES/ECB/PKCS5Padding";
    private static final String ALGORITHM = "AES";

    public static String encryptWithExceptions(String plainText, String secret, String transformation, String algorithm) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, UnsupportedEncodingException {
        Cipher cipher = Cipher.getInstance(transformation);
        cipher.init(1, new SecretKeySpec(secret.getBytes(), algorithm));
        byte[] encrypted = cipher.doFinal(plainText.getBytes());
        Base64 encoder = new Base64(32, linebreak, true);
        return new String(encoder.encode(encrypted), "UTF-8");
    }

    public static String decryptWithExceptions(String codedText, String secret, String transformation, String algorithm) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, UnsupportedEncodingException {
        Base64 encoder = new Base64(32, linebreak, true);
        byte[] encypted = encoder.decode(codedText.getBytes());
        Cipher cipher = Cipher.getInstance(transformation);
        cipher.init(2, new SecretKeySpec(secret.getBytes(), algorithm));
        byte[] decrypted = cipher.doFinal(encypted);
        return new String(decrypted, "UTF-8");
    }

    public static String encrypt(String plainText, String secret) {
        Conditions.checkNotNull(plainText, "Provided text");
        Conditions.checkNotNull(secret, "Secret key");
        String toReturn = "";
        try {
            toReturn = EncryptUtility.encryptWithExceptions(plainText, secret, TRANSFORMATION, ALGORITHM);
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap(ex);
        }
        return toReturn;
    }

    public static String decrypt(String codedText, String secret) {
        Conditions.checkNotNull(codedText, "Coded text");
        Conditions.checkNotNull(secret, "Secret key");
        String toReturn = "";
        try {
            toReturn = EncryptUtility.decryptWithExceptions(codedText, secret, TRANSFORMATION, ALGORITHM);
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap(ex);
        }
        return toReturn;
    }
}

