/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.util.Date;
import org.eclipse.osee.framework.jdk.core.result.XConsoleLogger;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;

public class ElapsedTime {
    Date startDate;
    Date endDate;
    private String name;
    private final boolean logStart;
    private boolean on = true;

    public ElapsedTime(String name) {
        this(name, true, true);
    }

    public ElapsedTime(String name, boolean on) {
        this(name, true, on);
    }

    public ElapsedTime(String name, boolean logStart, boolean on) {
        this.logStart = logStart;
        this.on = on;
        this.start(name);
    }

    public void start(String name) {
        this.name = name;
        this.startDate = new Date();
        if (this.isOn() && this.logStart) {
            XConsoleLogger.err(String.valueOf(name) + " - start " + DateUtil.getTimeStamp() + "\n", new Object[0]);
        }
    }

    public void logPoint(String pointName) {
        if (this.isOn()) {
            XConsoleLogger.err(String.valueOf(this.name) + " - [" + pointName + "] " + DateUtil.getTimeStamp() + "\n", new Object[0]);
        }
    }

    public String end() {
        return this.end(Units.MIN);
    }

    public String end(Units units) {
        return this.end(units, this.isOn());
    }

    public String end(Units units, boolean printToSysErr) {
        long timeSpent;
        if (!this.isOn()) {
            return "";
        }
        this.endDate = new Date();
        long time = timeSpent = this.endDate.getTime() - this.startDate.getTime();
        String milliseconds = "";
        if (units == Units.SEC) {
            time /= 1000L;
            milliseconds = "";
        } else if (units == Units.MIN) {
            time /= 60000L;
            milliseconds = " ( " + timeSpent + " ms ) ";
        }
        String str = String.format("%s - elapsed %d %s%s - start %s - end %s\n", this.name, time, units.name(), milliseconds, DateUtil.getDateStr(this.startDate, "hh:mm:ss:SS"), DateUtil.getDateStr(this.endDate, "hh:mm:ss:SS"));
        if (printToSysErr) {
            XConsoleLogger.err(str, new Object[0]);
        }
        return str;
    }

    public Long getTimeSpent() {
        Date endDate = new Date();
        return endDate.getTime() - this.startDate.getTime();
    }

    public void off() {
        this.setOn(false);
    }

    public boolean isOn() {
        return this.on;
    }

    public void setOn(boolean on) {
        this.on = on;
    }

    public static enum Units {
        SEC,
        MSEC,
        MIN;

    }
}

