/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public abstract class LazyObject<T> {
    private final AtomicReference<T> instanceReference = new AtomicReference();
    private final Object lock = new Object();
    private FutureTask<T> lastLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T get() {
        T object = this.instanceReference.get();
        if (object == null) {
            FutureTask<T> task;
            Object object2 = this.lock;
            synchronized (object2) {
                if (this.lastLoader != null) {
                    task = this.lastLoader;
                } else {
                    task = this.createLoaderTask();
                    this.lastLoader = task;
                    task.run();
                }
            }
            try {
                object = task.get();
                this.instanceReference.set(object);
            }
            catch (Exception ex) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                }
                throw OseeCoreException.wrap(cause);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invalidate() {
        Object object = this.lock;
        synchronized (object) {
            this.instanceReference.set(null);
            this.lastLoader = null;
        }
    }

    protected abstract FutureTask<T> createLoaderTask();

    protected Object getLock() {
        return this.lock;
    }
}

