/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.framework.jdk.core.type.Quad;

public class CompositeKeyQuadHashMap<KeyOne, KeyTwo, KeyThree, KeyFour, Value>
implements Map<Quad<KeyOne, KeyTwo, KeyThree, KeyFour>, Value> {
    private final Map<Quad<KeyOne, KeyTwo, KeyThree, KeyFour>, Value> map;
    private final ThreadLocal<Quad<KeyOne, KeyTwo, KeyThree, KeyFour>> threadLocalKey = new ThreadLocal<Quad<KeyOne, KeyTwo, KeyThree, KeyFour>>(){

        @Override
        protected Quad<KeyOne, KeyTwo, KeyThree, KeyFour> initialValue() {
            return new Quad<Object, Object, Object, Object>(null, null, null, null);
        }
    };

    public CompositeKeyQuadHashMap() {
        this.map = new HashMap<Quad<KeyOne, KeyTwo, KeyThree, KeyFour>, Value>();
    }

    public CompositeKeyQuadHashMap(Map<Quad<KeyOne, KeyTwo, KeyThree, KeyFour>, Value> map) {
        this.map = map;
    }

    public CompositeKeyQuadHashMap(int initialCapacity) {
        this.map = new HashMap<Quad<KeyOne, KeyTwo, KeyThree, KeyFour>, Value>(initialCapacity);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsKey(KeyOne a, KeyTwo b, KeyThree c, KeyFour d) {
        return this.map.containsKey(this.threadLocalKey.get().set(a, b, c, d));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<Quad<KeyOne, KeyTwo, KeyThree, KeyFour>, Value>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Value get(Object key) {
        if (Quad.class.isInstance(key)) {
            return this.map.get(key);
        }
        throw new IllegalArgumentException(String.format("Expected Type [CompositeKey], got type [%s].", key.getClass().getName()));
    }

    public Value get(KeyOne a, KeyTwo b, KeyThree c, KeyFour d) {
        return this.map.get(this.threadLocalKey.get().set(a, b, c, d));
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<Quad<KeyOne, KeyTwo, KeyThree, KeyFour>> keySet() {
        return this.map.keySet();
    }

    @Override
    public Value put(Quad<KeyOne, KeyTwo, KeyThree, KeyFour> key, Value value) {
        return this.map.put(key, value);
    }

    public Value put(KeyOne a, KeyTwo b, KeyThree c, KeyFour d, Value value) {
        return this.map.put(new Quad<KeyOne, KeyTwo, KeyThree, KeyFour>(a, b, c, d), value);
    }

    @Override
    public void putAll(Map<? extends Quad<KeyOne, KeyTwo, KeyThree, KeyFour>, ? extends Value> m) {
        this.map.putAll(m);
    }

    @Override
    public Value remove(Object key) {
        return this.map.remove(key);
    }

    public Value remove(KeyOne a, KeyTwo b, KeyThree c, KeyFour d) {
        return this.map.remove(this.threadLocalKey.get().set(a, b, c, d));
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<Value> values() {
        return this.map.values();
    }
}

