/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.text.rules;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.text.Rule;
import org.eclipse.osee.framework.jdk.core.text.change.ChOps;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class ReplaceAll
extends Rule {
    private static Pattern backReferencePattern = Pattern.compile("\\\\(\\d)");
    private final Pattern pattern;
    private final String[] replacements;
    private final Matcher backReferenceMatcher = backReferencePattern.matcher("");

    public ReplaceAll(Pattern pattern, String replacement) {
        this(pattern, new String[]{replacement});
    }

    public ReplaceAll(Pattern pattern, String[] replacements) {
        super(null);
        this.pattern = pattern;
        this.replacements = new String[replacements.length];
        int i = 0;
        while (i < replacements.length) {
            char[] chars = replacements[i].toCharArray();
            this.replacements[i] = new String(ChOps.embedNewLines(chars, 0, chars.length));
            ++i;
        }
    }

    public ReplaceAll(String patternStr, String[] replacements) {
        this(Pattern.compile(patternStr), replacements);
    }

    public ReplaceAll(String patternStr, String replacement) {
        this(Pattern.compile(patternStr), replacement);
    }

    @Override
    public ChangeSet computeChanges(CharSequence seq) {
        Matcher matcher = this.pattern.matcher(seq);
        ChangeSet changeSet = new ChangeSet(seq);
        while (matcher.find()) {
            this.ruleWasApplicable = true;
            int numGroups = matcher.groupCount();
            if (numGroups == 0) {
                changeSet.replace(matcher.start(), matcher.end(), this.replacements[0]);
                continue;
            }
            int i = 0;
            while (i < numGroups) {
                int start = matcher.start(i + 1);
                if (start > -1) {
                    this.backReferenceMatcher.reset(this.replacements[i]);
                    if (this.backReferenceMatcher.matches()) {
                        this.replacements[i] = matcher.group(Integer.parseInt(this.backReferenceMatcher.group(1)));
                    }
                    changeSet.replace(start, matcher.end(i + 1), this.replacements[i]);
                }
                ++i;
            }
        }
        return changeSet;
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage: java text.rules.ReplaceAll <pattern> <replace str or file> <directory> <fileName pattern>");
            return;
        }
        try {
            ReplaceAll rule = null;
            if (new File(args[1]).exists()) {
                ArrayList<String> list = Lib.readListFromFile(args[1]);
                String[] strs = new String[list.size()];
                list.toArray(strs);
                rule = new ReplaceAll(Pattern.compile(args[0]), strs);
            } else {
                rule = new ReplaceAll(Pattern.compile(args[0]), args[1]);
            }
            rule.process(Lib.recursivelyListFiles(new File(args[2]), Pattern.compile(args[3])));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

