/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.team;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.osee.framework.core.enums.OseeEnum;

public class ChangeTypes
extends OseeEnum {
    public static final String CHANGE_TYPE_PARAM_KEY = "ChangeType";
    private static final Long ENUM_ID = 23412356755L;
    private static final List<ChangeTypes> values = new ArrayList<ChangeTypes>();
    public static final ChangeTypes None = new ChangeTypes("None");
    public static final ChangeTypes Support = new ChangeTypes("Support", "");
    public static final ChangeTypes Problem = new ChangeTypes("Problem", "");
    public static final ChangeTypes Improvement = new ChangeTypes("Improvement", "");
    public static final ChangeTypes Refinement = new ChangeTypes("Refinement", "Small change");
    public static final ChangeTypes InitialDev = new ChangeTypes("Initial Dev", "");
    public static final ChangeTypes Fix = new ChangeTypes("Fix", "");
    public static final List<ChangeTypes> DEFAULT_CHANGE_TYPES = Arrays.asList(Improvement, Problem, Refinement, Support);
    private String description;

    public ChangeTypes() {
        super(ENUM_ID, "");
    }

    private ChangeTypes(String name) {
        this(name, "");
    }

    protected ChangeTypes(String name, String description) {
        super(ENUM_ID, name);
        this.description = description;
        values.add(this);
    }

    public String getDescription() {
        return this.description;
    }

    @JsonIgnore
    public Long getTypeId() {
        return ENUM_ID;
    }

    @JsonIgnore
    public OseeEnum getDefault() {
        return None;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonIgnore
    public boolean isNotNone() {
        return !this.equals((Object)None);
    }

    public static ChangeTypes valueOf(String changeTypeStr) {
        return ChangeTypes.valueOfOrNone(changeTypeStr);
    }

    public static ChangeTypes valueOfOrNone(String changeTypeStr) {
        ChangeTypes changeType = (ChangeTypes)None.get(changeTypeStr);
        if (changeType == null) {
            changeType = None;
        }
        return changeType;
    }

    public static ChangeTypes getChangeType(Object changeType) {
        String changeTypeName = "";
        if (changeType instanceof ChangeTypes) {
            changeTypeName = ((ChangeTypes)((Object)changeType)).getName();
        } else if (changeType instanceof String) {
            changeTypeName = (String)changeType;
        }
        for (ChangeTypes type : values) {
            if (!type.name().equals(changeTypeName)) continue;
            return type;
        }
        return None;
    }

    public static List<ChangeTypes> getValues() {
        return values;
    }

    public static List<String> getDefaultValuesStrs() {
        ArrayList<String> vals = new ArrayList<String>();
        for (ChangeTypes type : DEFAULT_CHANGE_TYPES) {
            vals.add(type.name());
        }
        return vals;
    }

    public static List<String> getValuesStrs() {
        ArrayList<String> vals = new ArrayList<String>();
        for (ChangeTypes type : values) {
            vals.add(type.name());
        }
        return vals;
    }
}

