/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.review;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.review.DecisionReviewOption;
import org.eclipse.osee.ats.api.review.IAtsDecisionReview;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResult;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.util.Result;

public class DecisionReviewOptions {
    private final AttributeTypeToken attributeType;
    private final AtsApi atsApi;
    private final IAtsDecisionReview decRev;

    public DecisionReviewOptions(IAtsDecisionReview decRev, AtsApi atsApi) {
        this.decRev = decRev;
        this.atsApi = atsApi;
        this.attributeType = AtsAttributeTypes.DecisionReviewOptions;
    }

    public AttributeTypeToken getAttributeType() {
        return this.attributeType;
    }

    public Set<DecisionReviewOption> getDecisionOptions() {
        String decString = this.atsApi.getAttributeResolver().getSoleAttributeValue(this.decRev, this.getAttributeType(), "");
        return DecisionReviewOptions.getDecisionOptions(decString, this.atsApi);
    }

    public static Set<DecisionReviewOption> getDecisionOptions(String decisionOptions, AtsApi atsApi) {
        LinkedHashSet<DecisionReviewOption> decOptions = new LinkedHashSet<DecisionReviewOption>();
        String[] stringArray = decisionOptions.split("[\n\r]+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            DecisionReviewOption state = new DecisionReviewOption("");
            String decsionOpt = stringArray[n2];
            Result result = state.setFromXml(decsionOpt);
            if (result.isFalse()) {
                atsApi.getLogger().error(result.getText(), new Object[0]);
            } else {
                decOptions.add(state);
            }
            ++n2;
        }
        return decOptions;
    }

    public DecisionReviewOption getDecisionOption(String name) {
        for (DecisionReviewOption opt : this.getDecisionOptions()) {
            if (!opt.getName().equals(name)) continue;
            return opt;
        }
        return null;
    }

    public void validateDecisionOptions(TransitionResults results) {
        DecisionReviewOptions.validateDecisionOptions(results, this.decRev, this.atsApi.getAttributeResolver().getSoleAttributeValue(this.decRev, this.getAttributeType(), ""), this.atsApi);
    }

    public static void validateDecisionOptions(TransitionResults results, IAtsDecisionReview decRev, String decisionOptions, AtsApi atsApi) {
        String[] stringArray = decisionOptions.split("[\n\r]+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            DecisionReviewOption state = new DecisionReviewOption("");
            String decsionOpt = stringArray[n2];
            Result result = state.setFromXml(decsionOpt);
            if (result.isFalse()) {
                results.addResult(decRev, new TransitionResult("Invalid Decision Option \"" + decsionOpt + "\" " + result.getText()));
            }
            ++n2;
        }
    }

    public String toXml(Set<DecisionReviewOption> opts) {
        StringBuffer sb = new StringBuffer();
        for (DecisionReviewOption opt : opts) {
            sb.append(opt.toXml());
            sb.append("\n");
        }
        return sb.toString().replaceFirst("\n$", "");
    }

    public void setDecisionOptions(String decisionOptions) {
        this.atsApi.getAttributeResolver().setSoleAttributeValue(this.decRev, (AttributeTypeId)this.getAttributeType(), this.toXml(DecisionReviewOptions.getDecisionOptions(decisionOptions, this.atsApi)));
    }
}

